/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.emi;

import dev.emi.emi.api.render.EmiRender;
import dev.emi.emi.api.render.EmiTooltipComponents;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import mekanism.api.MekanismAPI;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.text.EnumColor;
import mekanism.api.text.TextComponentUtil;
import mekanism.client.recipe_viewer.RecipeViewerUtils;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.util.text.TextUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.TooltipFlag;

@NothingNullByDefault
public class ChemicalEmiStack
extends EmiStack {
    private final Holder<Chemical> chemical;

    public ChemicalEmiStack(ChemicalStack stack) {
        this(stack.getChemicalHolder(), stack.getAmount());
    }

    public ChemicalEmiStack(Chemical chemical, DataComponentPatch ignored, long amount) {
        this(chemical.getAsHolder(), amount);
    }

    public ChemicalEmiStack(Holder<Chemical> chemical, long amount) {
        this.chemical = chemical;
        this.amount = amount;
    }

    public EmiStack copy() {
        ChemicalEmiStack e = new ChemicalEmiStack(this.chemical, this.amount);
        e.setChance(this.chance);
        e.setRemainder(this.getRemainder().copy());
        e.comparison = this.comparison;
        return e;
    }

    public void render(GuiGraphics graphics, int x, int y, float delta, int flags) {
        if ((flags & 1) != 0) {
            int color = MekanismRenderer.getTint(this.chemical);
            TextureAtlasSprite sprite = MekanismRenderer.getChemicalTexture(this.chemical);
            float red = MekanismRenderer.getRed(color);
            float green = MekanismRenderer.getGreen(color);
            float blue = MekanismRenderer.getBlue(color);
            graphics.blit(x, y, 0, 16, 16, sprite, red, green, blue, 1.0f);
        }
        if ((flags & 8) != 0) {
            EmiRender.renderRemainderIcon((EmiIngredient)this, (GuiGraphics)graphics, (int)x, (int)y);
        }
    }

    public ChemicalStack getStack() {
        if (this.isEmpty()) {
            return ChemicalStack.EMPTY;
        }
        return new ChemicalStack(this.chemical, this.amount);
    }

    public boolean isEmpty() {
        return this.amount <= 0L || this.chemical.is(MekanismAPI.EMPTY_CHEMICAL_KEY);
    }

    public DataComponentPatch getComponentChanges() {
        return DataComponentPatch.EMPTY;
    }

    public Chemical getKey() {
        return (Chemical)this.chemical.value();
    }

    public ResourceLocation getId() {
        ResourceKey key = this.chemical.getKey();
        return key == null ? MekanismAPI.CHEMICAL_REGISTRY.getDefaultKey() : key.location();
    }

    public List<Component> getTooltipText() {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Component> tooltips = new ArrayList<Component>();
        tooltips.add(this.getName());
        ChemicalStack stack = new ChemicalStack(this.chemical, this.amount > 1L ? this.amount : 1L);
        stack.appendHoverText(RecipeViewerUtils.getRVTooltipContext(), tooltips, (TooltipFlag)TooltipFlag.NORMAL);
        return tooltips;
    }

    public List<ClientTooltipComponent> getTooltip() {
        List<ClientTooltipComponent> tooltips = this.getTooltipText().stream().map(EmiTooltipComponents::of).collect(Collectors.toList());
        if (this.amount > 1L) {
            tooltips.add(EmiTooltipComponents.of((Component)MekanismLang.GENERIC_MB.translateColored(EnumColor.GRAY, TextUtils.format(this.amount))));
        }
        EmiTooltipComponents.appendModName(tooltips, (String)this.getId().getNamespace());
        tooltips.addAll(super.getTooltip());
        return tooltips;
    }

    public Component getName() {
        return TextComponentUtil.build(this.chemical);
    }
}

