/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.radiation;

import com.google.common.collect.Table;
import java.util.List;
import mekanism.api.Chunk3D;
import mekanism.api.MekanismAPI;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.radiation.IRadiationSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public interface IRadiationManager {
    public static final IRadiationManager INSTANCE = MekanismAPI.getService(IRadiationManager.class);

    public boolean isRadiationEnabled();

    public double baselineRadiation();

    public double minRadiationMagnitude();

    public DamageSource getRadiationDamageSource(RegistryAccess var1);

    public ResourceKey<DamageType> getRadiationDamageTypeKey();

    public double getRadiationLevel(Level var1, BlockPos var2);

    @Deprecated(forRemoval=true, since="10.7.15")
    default public double getRadiationLevel(GlobalPos pos) {
        Level level = IRadiationManager.backCompat$getLevel((ResourceKey<Level>)pos.dimension());
        if (level != null) {
            return this.getRadiationLevel(level, pos.pos());
        }
        return this.baselineRadiation();
    }

    public double getRadiationLevel(Entity var1);

    @Deprecated(forRemoval=true, since="10.7.15")
    public Table<Chunk3D, GlobalPos, IRadiationSource> getRadiationSources();

    public List<IRadiationSource> getRadiationSources(Level var1, int var2, int var3);

    public void removeRadiationSources(Level var1, int var2, int var3);

    @Deprecated(forRemoval=true, since="10.7.15")
    default public void removeRadiationSources(Chunk3D chunk) {
        Level level = IRadiationManager.backCompat$getLevel(chunk.dimension);
        if (level != null) {
            this.removeRadiationSources(level, chunk.x, chunk.z);
        }
    }

    public void removeRadiationSource(Level var1, BlockPos var2);

    @Deprecated(forRemoval=true, since="10.7.15")
    default public void removeRadiationSource(GlobalPos pos) {
        Level level = IRadiationManager.backCompat$getLevel((ResourceKey<Level>)pos.dimension());
        if (level != null) {
            this.removeRadiationSource(level, pos.pos());
        }
    }

    public void radiate(Level var1, BlockPos var2, double var3);

    @Deprecated(forRemoval=true, since="10.7.15")
    default public void radiate(GlobalPos pos, double magnitude) {
        Level level = IRadiationManager.backCompat$getLevel((ResourceKey<Level>)pos.dimension());
        if (level != null) {
            this.radiate(level, pos.pos(), magnitude);
        }
    }

    public void radiate(LivingEntity var1, double var2);

    public void dumpRadiation(Level var1, BlockPos var2, IChemicalHandler var3, boolean var4);

    @Deprecated(forRemoval=true, since="10.7.15")
    default public void dumpRadiation(GlobalPos pos, IChemicalHandler chemicalHandler, boolean clearRadioactive) {
        Level level = IRadiationManager.backCompat$getLevel((ResourceKey<Level>)pos.dimension());
        if (level != null) {
            this.dumpRadiation(level, pos.pos(), chemicalHandler, clearRadioactive);
        }
    }

    public void dumpRadiation(Level var1, BlockPos var2, List<IChemicalTank> var3, boolean var4);

    @Deprecated(forRemoval=true, since="10.7.15")
    default public void dumpRadiation(GlobalPos pos, List<IChemicalTank> chemicalTanks, boolean clearRadioactive) {
        Level level = IRadiationManager.backCompat$getLevel((ResourceKey<Level>)pos.dimension());
        if (level != null) {
            this.dumpRadiation(level, pos.pos(), chemicalTanks, clearRadioactive);
        }
    }

    public boolean dumpRadiation(Level var1, BlockPos var2, ChemicalStack var3);

    @Deprecated(forRemoval=true, since="10.7.15")
    default public boolean dumpRadiation(GlobalPos pos, ChemicalStack stack) {
        Level level = IRadiationManager.backCompat$getLevel((ResourceKey<Level>)pos.dimension());
        if (level != null) {
            return this.dumpRadiation(level, pos.pos(), stack);
        }
        return false;
    }

    @ApiStatus.Internal
    @Nullable
    private static Level backCompat$getLevel(ResourceKey<Level> dimension) {
        MinecraftServer currentServer = ServerLifecycleHooks.getCurrentServer();
        if (currentServer == null) {
            return null;
        }
        return currentServer.getLevel(dimension);
    }
}

