/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.math;

import java.util.List;

public class MathUtils {
    static final long UNSIGNED_MASK = Long.MAX_VALUE;

    private MathUtils() {
    }

    public static int clampToInt(double d) {
        if (d < 2.147483647E9) {
            return (int)d;
        }
        return Integer.MAX_VALUE;
    }

    public static int clampToInt(long l) {
        if (l < Integer.MAX_VALUE) {
            return (int)l;
        }
        return Integer.MAX_VALUE;
    }

    public static long clampToLong(double d) {
        if (d < 9.223372036854776E18) {
            return (long)d;
        }
        return Long.MAX_VALUE;
    }

    public static long ceilToLong(double d) {
        return MathUtils.clampToLong(Math.ceil(d));
    }

    public static <TYPE> TYPE getByIndexMod(TYPE[] elements, int index) {
        if (index < 0) {
            return elements[Math.floorMod(index, elements.length)];
        }
        return elements[index % elements.length];
    }

    public static <TYPE> TYPE getByIndexMod(List<TYPE> elements, int index) {
        if (index < 0) {
            return elements.get(Math.floorMod(index, elements.size()));
        }
        return elements.get(index % elements.size());
    }

    public static double divideToLevel(double numerator, double toDivide) {
        return toDivide == 0.0 || numerator > toDivide ? 1.0 : numerator / toDivide;
    }

    public static long addClamped(long x, long y) {
        long r = x + y;
        if (((x ^ r) & (y ^ r)) < 0L) {
            return Long.MAX_VALUE;
        }
        return r;
    }

    public static long multiplyClamped(long x, long y) {
        long ay;
        long r = x * y;
        long ax = Math.abs(x);
        if ((ax | (ay = Math.abs(y))) >>> 31 != 0L && (y != 0L && r / y != x || x == Long.MIN_VALUE && y == -1L)) {
            return Long.MAX_VALUE;
        }
        return r;
    }
}

