/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.move;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.object.MemoryTest;
import net.tslat.smartbrainlib.util.BrainUtils;

public class StayWithinDistanceOfAttackTarget<E extends PathfinderMob>
extends ExtendedBehaviour<E> {
    private static final MemoryTest MEMORY_REQUIREMENTS = MemoryTest.builder(2).hasMemory(MemoryModuleType.ATTACK_TARGET).noMemory(MemoryModuleType.WALK_TARGET);
    protected BiFunction<E, LivingEntity, Float> distMax = (entity, target) -> Float.valueOf(20.0f);
    protected BiFunction<E, LivingEntity, Float> distMin = (entity, target) -> Float.valueOf(5.0f);
    protected Predicate<E> stopWhen = entity -> false;
    protected float speedMod = 1.0f;
    protected float repositionSpeedMod = 1.3f;

    public StayWithinDistanceOfAttackTarget<E> minDistance(float distance) {
        return this.minDistance((entity, target) -> Float.valueOf(distance));
    }

    public StayWithinDistanceOfAttackTarget<E> minDistance(BiFunction<E, LivingEntity, Float> distance) {
        this.distMin = distance;
        return this;
    }

    public StayWithinDistanceOfAttackTarget<E> maxDistance(float distance) {
        return this.maxDistance((entity, target) -> Float.valueOf(distance));
    }

    public StayWithinDistanceOfAttackTarget<E> maxDistance(BiFunction<E, LivingEntity, Float> distance) {
        this.distMax = distance;
        return this;
    }

    public StayWithinDistanceOfAttackTarget<E> speedMod(float modifier) {
        this.speedMod = modifier;
        return this;
    }

    public StayWithinDistanceOfAttackTarget<E> repositionSpeedMod(float modifier) {
        this.speedMod = modifier;
        return this;
    }

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    @Override
    protected boolean shouldKeepRunning(E entity) {
        return BrainUtils.hasMemory(entity, MemoryModuleType.ATTACK_TARGET) && !this.stopWhen.test(entity);
    }

    @Override
    protected void tick(E entity) {
        LivingEntity target = BrainUtils.getTargetOfEntity(entity);
        double distanceToTarget = target.distanceToSqr(entity);
        float maxDist = this.distMax.apply(entity, target).floatValue();
        double maxDistSq = Math.pow(maxDist, 2.0);
        double minDistSq = Math.pow(this.distMin.apply(entity, target).floatValue(), 2.0);
        PathNavigation navigation = entity.getNavigation();
        if (distanceToTarget > maxDistSq || !entity.hasLineOfSight((Entity)target)) {
            if (navigation.isDone()) {
                navigation.moveTo((Entity)target, (double)this.repositionSpeedMod);
            }
            return;
        }
        if (distanceToTarget < minDistSq) {
            Vec3 runPos;
            if (navigation.isDone() && (runPos = DefaultRandomPos.getPosAway(entity, (int)((int)maxDist), (int)5, (Vec3)target.position())) != null) {
                navigation.moveTo(navigation.createPath(BlockPos.containing((Position)runPos), 1), (double)this.repositionSpeedMod);
            }
            return;
        }
        if (navigation instanceof GroundPathNavigation) {
            navigation.stop();
        }
        BrainUtils.setMemory(entity, MemoryModuleType.LOOK_TARGET, new EntityTracker((Entity)target, true));
        if (distanceToTarget > maxDistSq * 0.5) {
            entity.lookAt((Entity)target, 30.0f, 30.0f);
            entity.getMoveControl().strafe(0.5f * this.speedMod, 0.0f);
        } else if (distanceToTarget < minDistSq * 3.0) {
            entity.lookAt((Entity)target, 30.0f, 30.0f);
            entity.getMoveControl().strafe(-0.5f * this.speedMod, 0.0f);
        }
    }
}

