/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.client.ColorHandlers;
import me.desht.pneumaticcraft.common.PNCDamageSource;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.item.ICustomTooltipName;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PlasticBrickBlock
extends Block
implements ColorHandlers.ITintableBlock {
    private static final VoxelShape COLLISION_SHAPE = PlasticBrickBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    private static final EnumProperty<PartType> X_PART = EnumProperty.create((String)"x_part", PartType.class);
    private static final EnumProperty<PartType> Z_PART = EnumProperty.create((String)"z_part", PartType.class);
    private final DyeColor dyeColor;
    private final int tintColor;

    public PlasticBrickBlock(BlockBehaviour.Properties props, DyeColor dyeColor) {
        super(props);
        this.dyeColor = dyeColor;
        this.tintColor = dyeColor.getTextureDiffuseColor();
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(X_PART, (Comparable)((Object)PartType.NONE))).setValue(Z_PART, (Comparable)((Object)PartType.NONE)));
    }

    public DyeColor getDyeColor() {
        return this.dyeColor;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{X_PART, Z_PART});
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return COLLISION_SHAPE;
    }

    public VoxelShape getBlockSupportShape(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return Shapes.block();
    }

    public VoxelShape getVisualShape(BlockState pState, BlockGetter pReader, BlockPos pPos, CollisionContext pContext) {
        return Shapes.block();
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState state = super.getStateForPlacement(ctx);
        return this.calcParts((LevelAccessor)ctx.getLevel(), ctx.getClickedPos(), state);
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return this.calcParts(worldIn, currentPos, stateIn);
    }

    protected boolean hurtsToStepOn() {
        return true;
    }

    private BlockState calcParts(LevelAccessor world, BlockPos pos, BlockState stateIn) {
        boolean zRight;
        boolean xRight;
        Block w = world.getBlockState(pos.west()).getBlock();
        Block e = world.getBlockState(pos.east()).getBlock();
        PartType xType = PartType.NONE;
        boolean bl = xRight = (pos.getX() + pos.getY() & 1) == 0;
        if (xRight && w == this) {
            xType = PartType.RIGHT;
        } else if (!xRight && e == this) {
            xType = PartType.LEFT;
        }
        Block n = world.getBlockState(pos.north()).getBlock();
        Block s = world.getBlockState(pos.south()).getBlock();
        PartType zType = PartType.NONE;
        boolean bl2 = zRight = (pos.getZ() + pos.getY() & 1) == 0;
        if (zRight && s == this) {
            zType = PartType.RIGHT;
        } else if (!zRight && n == this) {
            zType = PartType.LEFT;
        }
        return (BlockState)((BlockState)stateIn.setValue(X_PART, (Comparable)((Object)xType))).setValue(Z_PART, (Comparable)((Object)zType));
    }

    public void entityInside(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        LivingEntity livingEntity;
        if (this.hurtsToStepOn() && entityIn instanceof LivingEntity && !this.isEntitySafe(livingEntity = (LivingEntity)entityIn)) {
            entityIn.hurt(PNCDamageSource.plasticBlock(worldIn), ((Double)ConfigHelper.common().general.plasticBrickDamage.get()).floatValue());
            livingEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 40, 1));
        }
    }

    private boolean isEntitySafe(LivingEntity entity) {
        IDrone drone;
        return !entity.getItemBySlot(EquipmentSlot.FEET).isEmpty() || entity instanceof IDrone && (drone = (IDrone)entity).getUpgrades(ModUpgrades.ARMOR.get()) > 0;
    }

    @Override
    public int getTintColor(BlockState state, @Nullable BlockAndTintGetter world, @Nullable BlockPos pos, int tintIndex) {
        return this.tintColor;
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    static enum PartType implements StringRepresentable
    {
        NONE("none"),
        LEFT("left"),
        RIGHT("right");

        private final String name;

        private PartType(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }

    public static class ItemPlasticBrick
    extends BlockItem
    implements ICustomTooltipName {
        public ItemPlasticBrick(PlasticBrickBlock blockPlasticBrick) {
            super((Block)blockPlasticBrick, ModItems.defaultProps());
        }

        @Override
        public String getCustomTooltipTranslationKey() {
            return "block.pneumaticcraft.plastic_brick";
        }
    }
}

