/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.pneumatic_armor.hacking;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;

public interface IHackableBlock {
    @Nonnull
    public ResourceLocation getHackableId();

    default public boolean canHack(BlockGetter level, BlockPos pos, BlockState state, Player player) {
        return true;
    }

    public void addInfo(BlockGetter var1, BlockPos var2, List<Component> var3, Player var4);

    public void addPostHackInfo(BlockGetter var1, BlockPos var2, List<Component> var3, Player var4);

    public int getHackTime(BlockGetter var1, BlockPos var2, Player var3);

    public void onHackComplete(Level var1, BlockPos var2, Player var3);

    default public boolean afterHackTick(BlockGetter world, BlockPos pos) {
        return false;
    }

    default public Optional<BlockHitResult> fakeRayTrace(Player player, BlockPos targetPos) {
        BlockState state = player.level().getBlockState(targetPos);
        AABB aabb = state.getShape((BlockGetter)player.level(), targetPos).bounds().move(targetPos);
        Optional hit = aabb.clip(player.getEyePosition(1.0f), aabb.getCenter());
        Direction dir = Direction.orderedByNearest((Entity)player)[0];
        return hit.map(v -> new BlockHitResult(v, dir.getOpposite(), targetPos, false));
    }
}

