/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.integration;

import java.util.function.Function;
import javax.annotation.Nonnull;
import mcjty.theoneprobe.api.IBlockDisplayOverride;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.api.FluxDataComponents;
import sonar.fluxnetworks.api.FluxTranslate;
import sonar.fluxnetworks.api.energy.EnergyType;
import sonar.fluxnetworks.common.data.FluxDeviceConfigComponent;
import sonar.fluxnetworks.common.device.TileFluxDevice;
import sonar.fluxnetworks.common.util.FluxUtils;

public class TOPIntegration
implements Function<ITheOneProbe, Void> {
    @Override
    public Void apply(@Nonnull ITheOneProbe iTheOneProbe) {
        iTheOneProbe.registerProvider((IProbeInfoProvider)new FluxDeviceInfoProvider());
        iTheOneProbe.registerBlockDisplayOverride((IBlockDisplayOverride)new FluxDeviceDisplayOverride());
        return null;
    }

    public static class FluxDeviceInfoProvider
    implements IProbeInfoProvider {
        private static final ResourceLocation ID = FluxNetworks.location("device_provider");

        public ResourceLocation getID() {
            return ID;
        }

        public void addProbeInfo(ProbeMode probeMode, IProbeInfo probeInfo, Player player, Level level, BlockState blockState, IProbeHitData hitData) {
            if (!FluxConfig.enableOneProbeBasicInfo && !FluxConfig.enableOneProbeAdvancedInfo) {
                return;
            }
            BlockEntity blockEntity = level.getBlockEntity(hitData.getPos());
            if (!(blockEntity instanceof TileFluxDevice)) {
                return;
            }
            TileFluxDevice device = (TileFluxDevice)blockEntity;
            if (FluxConfig.enableOneProbeBasicInfo) {
                if (device.getNetwork().isValid()) {
                    probeInfo.text((Component)Component.literal((String)device.getNetwork().getNetworkName()).withStyle(ChatFormatting.AQUA));
                } else {
                    probeInfo.text((Component)FluxTranslate.ERROR_NO_SELECTED.makeComponent().withStyle(ChatFormatting.AQUA));
                }
                probeInfo.text((Component)Component.literal((String)FluxUtils.getTransferInfo(device, EnergyType.FE)));
                if (player.isShiftKeyDown()) {
                    if (device.getDeviceType().isStorage()) {
                        probeInfo.text((Component)FluxTranslate.ENERGY_STORED.makeComponent().append(": " + String.valueOf(ChatFormatting.GREEN) + EnergyType.FE.getStorage(device.getTransferBuffer())));
                    } else {
                        probeInfo.text((Component)FluxTranslate.INTERNAL_BUFFER.makeComponent().append(": " + String.valueOf(ChatFormatting.GREEN) + EnergyType.FE.getStorage(device.getTransferBuffer())));
                    }
                }
            }
            if (FluxConfig.enableOneProbeAdvancedInfo && (!FluxConfig.enableOneProbeSneaking || player.isShiftKeyDown())) {
                if (device.getDisableLimit()) {
                    probeInfo.text((Component)FluxTranslate.TRANSFER_LIMIT.makeComponent().append(": " + String.valueOf(ChatFormatting.GREEN) + String.valueOf(FluxTranslate.UNLIMITED)));
                } else {
                    probeInfo.text((Component)FluxTranslate.TRANSFER_LIMIT.makeComponent().append(": " + String.valueOf(ChatFormatting.GREEN) + EnergyType.FE.getUsage(device.getRawLimit())));
                }
                if (device.getSurgeMode()) {
                    probeInfo.text((Component)FluxTranslate.PRIORITY.makeComponent().append(": " + String.valueOf(ChatFormatting.GREEN) + String.valueOf(FluxTranslate.SURGE)));
                } else {
                    probeInfo.text((Component)FluxTranslate.PRIORITY.makeComponent().append(": " + String.valueOf(ChatFormatting.GREEN) + device.getRawPriority()));
                }
                if (device.isForcedLoading()) {
                    probeInfo.text((Component)FluxTranslate.FORCED_LOADING.makeComponent().withStyle(ChatFormatting.GOLD));
                }
            }
        }
    }

    public static class FluxDeviceDisplayOverride
    implements IBlockDisplayOverride {
        public boolean overrideStandardInfo(ProbeMode probeMode, IProbeInfo probeInfo, Player player, @Nonnull Level level, BlockState blockState, @Nonnull IProbeHitData hitData) {
            BlockEntity blockEntity = level.getBlockEntity(hitData.getPos());
            if (blockEntity instanceof TileFluxDevice) {
                TileFluxDevice device = (TileFluxDevice)blockEntity;
                ItemStack displayStack = device.getDisplayStack().copy();
                FluxDeviceConfigComponent c = (FluxDeviceConfigComponent)displayStack.getOrDefault(FluxDataComponents.FLUX_CONFIG, (Object)FluxDeviceConfigComponent.EMPTY);
                displayStack.set(FluxDataComponents.FLUX_CONFIG, (Object)c.withNetworkAndName(device.getNetworkID(), device.getCustomName()));
                probeInfo.horizontal().item(displayStack).vertical().itemLabel(displayStack).text((Component)Component.literal((String)(String.valueOf(TextStyleClass.MODNAME) + "Flux Networks")));
                return true;
            }
            return false;
        }
    }
}

