/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.entity.custom.gauntlet;

import com.cerbon.bosses_of_mass_destruction.entity.custom.gauntlet.GauntletEntity;
import com.cerbon.bosses_of_mass_destruction.entity.custom.gauntlet.LaserAction;
import com.cerbon.bosses_of_mass_destruction.entity.util.IDataAccessorHandler;
import com.cerbon.bosses_of_mass_destruction.entity.util.IEntityEventHandler;
import com.cerbon.bosses_of_mass_destruction.entity.util.IEntityTick;
import com.cerbon.bosses_of_mass_destruction.particle.BMDParticles;
import com.cerbon.cerbons_api.api.general.data.HistoricalData;
import com.cerbon.cerbons_api.api.general.event.EventScheduler;
import com.cerbon.cerbons_api.api.general.event.IEvent;
import com.cerbon.cerbons_api.api.general.event.TimedEvent;
import com.cerbon.cerbons_api.api.general.particle.ClientParticleBuilder;
import com.cerbon.cerbons_api.api.static_utilities.MobUtils;
import com.cerbon.cerbons_api.api.static_utilities.RandomUtils;
import com.cerbon.cerbons_api.api.static_utilities.Vec3Colors;
import com.cerbon.cerbons_api.api.static_utilities.VecUtils;
import com.mojang.datafixers.util.Pair;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class GauntletClientLaserHandler
implements IEntityTick<Level>,
IDataAccessorHandler,
IEntityEventHandler {
    private final GauntletEntity entity;
    private final EventScheduler eventScheduler;
    private LivingEntity cachedBeamTarget;
    private final HistoricalData<Pair<Vec3, Vec3>> laserRenderPositions = new HistoricalData((Object)Pair.of((Object)Vec3.ZERO, (Object)Vec3.ZERO), 8);
    public final ClientParticleBuilder laserChargeParticles = new ClientParticleBuilder((ParticleOptions)BMDParticles.SPARKLES.get()).brightness(0xF000F0).color(Vec3Colors.LASER_RED).colorVariation(0.2);

    public GauntletClientLaserHandler(GauntletEntity entity, EventScheduler eventScheduler) {
        this.entity = entity;
        this.eventScheduler = eventScheduler;
    }

    @Override
    public void tick(Level level) {
        LivingEntity beamTarget = this.getBeamTarget();
        if (beamTarget != null) {
            Vec3 centerBoxOffset = beamTarget.getBoundingBox().getCenter().subtract(beamTarget.position());
            this.laserRenderPositions.add((Object)Pair.of((Object)beamTarget.position().add(centerBoxOffset), (Object)MobUtils.lastRenderPos((Entity)beamTarget).add(centerBoxOffset)));
        } else {
            this.laserRenderPositions.clear();
        }
    }

    public boolean shouldRenderLaser() {
        return this.laserRenderPositions.size() > 1;
    }

    public Pair<Vec3, Vec3> getLaserRenderPos() {
        Pair laserPos = (Pair)this.laserRenderPositions.getAll().get(0);
        Vec3 newPos = LaserAction.extendLaser((Entity)this.entity, (Vec3)laserPos.getFirst());
        Vec3 prevPos = LaserAction.extendLaser((Entity)this.entity, (Vec3)laserPos.getSecond());
        BlockHitResult newResult = this.entity.level().clip(new ClipContext(MobUtils.eyePos((Entity)this.entity), newPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.entity));
        BlockHitResult prevResult = this.entity.level().clip(new ClipContext(MobUtils.eyePos((Entity)this.entity), prevPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.entity));
        Vec3 colNewPos = newResult.getType() == HitResult.Type.BLOCK ? newResult.getLocation() : newPos;
        Vec3 colPrevPos = prevResult.getType() == HitResult.Type.BLOCK ? prevResult.getLocation() : prevPos;
        return Pair.of((Object)colNewPos, (Object)colPrevPos);
    }

    private LivingEntity getBeamTarget() {
        if (!this.hasBeamTarget()) {
            return null;
        }
        if (this.entity.level().isClientSide()) {
            if (this.cachedBeamTarget != null) {
                return this.cachedBeamTarget;
            }
            Entity entity1 = this.entity.level().getEntity(((Integer)this.entity.getEntityData().get(GauntletEntity.laserTarget)).intValue());
            if (entity1 instanceof LivingEntity) {
                LivingEntity livingEntity;
                this.cachedBeamTarget = livingEntity = (LivingEntity)entity1;
                return this.cachedBeamTarget;
            }
            return null;
        }
        return this.entity.getTarget();
    }

    private boolean hasBeamTarget() {
        return (Integer)this.entity.getEntityData().get(GauntletEntity.laserTarget) != 0;
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
        if (GauntletEntity.laserTarget == data) {
            this.cachedBeamTarget = null;
        }
    }

    public void initDataTracker() {
        this.entity.getEntityData().set(GauntletEntity.laserTarget, (Object)0);
    }

    @Override
    public void handleEntityEvent(byte status) {
        if (status == 8) {
            this.eventScheduler.addEvent((IEvent)new TimedEvent(() -> {
                Vec3 lookVec = this.entity.getLookAngle();
                for (int i = 0; i <= 1; ++i) {
                    Vec3 circularOffset = VecUtils.rotateVector((Vec3)lookVec.cross(VecUtils.yAxis), (Vec3)lookVec, (double)RandomUtils.range((int)0, (int)359));
                    Vec3 velocity = circularOffset.normalize().reverse().scale(0.07).add(this.entity.getDeltaMovement().scale(1.2));
                    Vec3 position = MobUtils.eyePos((Entity)this.entity).add(circularOffset).add(lookVec.scale(0.5));
                    this.laserChargeParticles.build(position, velocity);
                }
            }, 0, 85, () -> false));
        }
    }
}

