/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.util;

import guideme.internal.shaded.lucene.search.DocIdSetIterator;
import guideme.internal.shaded.lucene.util.FixedBitSet;

public class DocBaseBitSetIterator
extends DocIdSetIterator {
    private final FixedBitSet bits;
    private final int length;
    private final long cost;
    private final int docBase;
    private int doc = -1;

    public DocBaseBitSetIterator(FixedBitSet bits, long cost, int docBase) {
        if (cost < 0L) {
            throw new IllegalArgumentException("cost must be >= 0, got " + cost);
        }
        if ((docBase & 0x3F) != 0) {
            throw new IllegalArgumentException("docBase need to be a multiple of 64, got " + docBase);
        }
        this.bits = bits;
        this.length = bits.length() + docBase;
        this.cost = cost;
        this.docBase = docBase;
    }

    public FixedBitSet getBitSet() {
        return this.bits;
    }

    @Override
    public int docID() {
        return this.doc;
    }

    public int getDocBase() {
        return this.docBase;
    }

    @Override
    public int nextDoc() {
        return this.advance(this.doc + 1);
    }

    @Override
    public int advance(int target) {
        if (target >= this.length) {
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }
        int next = this.bits.nextSetBit(Math.max(0, target - this.docBase));
        if (next == Integer.MAX_VALUE) {
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }
        this.doc = next + this.docBase;
        return this.doc;
    }

    @Override
    public long cost() {
        return this.cost;
    }
}

