/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.store;

import guideme.internal.shaded.lucene.internal.tests.TestSecrets;
import guideme.internal.shaded.lucene.store.IndexInput;
import java.io.IOException;
import java.util.concurrent.CopyOnWriteArrayList;

public class FilterIndexInput
extends IndexInput {
    static final CopyOnWriteArrayList<Class<?>> TEST_FILTER_INPUTS = new CopyOnWriteArrayList();
    protected final IndexInput in;

    public static IndexInput unwrap(IndexInput in) {
        while (in instanceof FilterIndexInput) {
            in = ((FilterIndexInput)in).in;
        }
        return in;
    }

    public static IndexInput unwrapOnlyTest(IndexInput in) {
        while (in instanceof FilterIndexInput && TEST_FILTER_INPUTS.contains(in.getClass())) {
            in = ((FilterIndexInput)in).in;
        }
        return in;
    }

    public FilterIndexInput(String resourceDescription, IndexInput in) {
        super(resourceDescription);
        this.in = in;
    }

    public IndexInput getDelegate() {
        return this.in;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public long getFilePointer() {
        return this.in.getFilePointer();
    }

    @Override
    public void seek(long pos) throws IOException {
        this.in.seek(pos);
    }

    @Override
    public long length() {
        return this.in.length();
    }

    @Override
    public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
        return this.in.slice(sliceDescription, offset, length);
    }

    @Override
    public byte readByte() throws IOException {
        return this.in.readByte();
    }

    @Override
    public void readBytes(byte[] b, int offset, int len) throws IOException {
        this.in.readBytes(b, offset, len);
    }

    static {
        TestSecrets.setFilterInputIndexAccess(TEST_FILTER_INPUTS::add);
    }
}

