/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.queries.function.valuesource;

import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.queries.function.FunctionValues;
import guideme.internal.shaded.lucene.queries.function.ValueSource;
import guideme.internal.shaded.lucene.queries.function.docvalues.FloatDocValues;
import guideme.internal.shaded.lucene.search.IndexSearcher;
import java.io.IOException;
import java.util.Map;

public class LinearFloatFunction
extends ValueSource {
    protected final ValueSource source;
    protected final float slope;
    protected final float intercept;

    public LinearFloatFunction(ValueSource source, float slope, float intercept) {
        this.source = source;
        this.slope = slope;
        this.intercept = intercept;
    }

    @Override
    public String description() {
        return this.slope + "*float(" + this.source.description() + ")+" + this.intercept;
    }

    @Override
    public FunctionValues getValues(Map<Object, Object> context, LeafReaderContext readerContext) throws IOException {
        final FunctionValues vals = this.source.getValues(context, readerContext);
        return new FloatDocValues(this){

            @Override
            public float floatVal(int doc) throws IOException {
                return vals.floatVal(doc) * LinearFloatFunction.this.slope + LinearFloatFunction.this.intercept;
            }

            @Override
            public boolean exists(int doc) throws IOException {
                return vals.exists(doc);
            }

            @Override
            public String toString(int doc) throws IOException {
                return LinearFloatFunction.this.slope + "*float(" + vals.toString(doc) + ")+" + LinearFloatFunction.this.intercept;
            }
        };
    }

    @Override
    public void createWeight(Map<Object, Object> context, IndexSearcher searcher) throws IOException {
        this.source.createWeight(context, searcher);
    }

    @Override
    public int hashCode() {
        int h = Float.floatToIntBits(this.slope);
        h = h >>> 2 | h << 30;
        h += Float.floatToIntBits(this.intercept);
        h ^= h << 14 | h >>> 19;
        return h + this.source.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (LinearFloatFunction.class != o.getClass()) {
            return false;
        }
        LinearFloatFunction other = (LinearFloatFunction)o;
        return this.slope == other.slope && this.intercept == other.intercept && this.source.equals(other.source);
    }
}

