/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.queries.function.valuesource;

import guideme.internal.shaded.lucene.index.DocValues;
import guideme.internal.shaded.lucene.index.IndexReader;
import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.index.MultiTerms;
import guideme.internal.shaded.lucene.index.ReaderUtil;
import guideme.internal.shaded.lucene.index.SortedDocValues;
import guideme.internal.shaded.lucene.index.Terms;
import guideme.internal.shaded.lucene.index.TermsEnum;
import guideme.internal.shaded.lucene.queries.function.FunctionValues;
import guideme.internal.shaded.lucene.queries.function.docvalues.IntDocValues;
import guideme.internal.shaded.lucene.queries.function.valuesource.FieldCacheSource;
import guideme.internal.shaded.lucene.util.BytesRef;
import java.io.IOException;
import java.util.Map;

public class JoinDocFreqValueSource
extends FieldCacheSource {
    public static final String NAME = "joindf";
    protected final String qfield;

    public JoinDocFreqValueSource(String field, String qfield) {
        super(field);
        this.qfield = qfield;
    }

    @Override
    public String description() {
        return "joindf(" + this.field + ":(" + this.qfield + "))";
    }

    @Override
    public FunctionValues getValues(Map<Object, Object> context, LeafReaderContext readerContext) throws IOException {
        final SortedDocValues terms = DocValues.getSorted(readerContext.reader(), this.field);
        IndexReader top = ReaderUtil.getTopLevelContext(readerContext).reader();
        Terms t = MultiTerms.getTerms(top, this.qfield);
        final TermsEnum termsEnum = t == null ? TermsEnum.EMPTY : t.iterator();
        return new IntDocValues(this, this){
            int lastDocID;
            {
                super(vs);
                this.lastDocID = -1;
            }

            @Override
            public int intVal(int doc) throws IOException {
                BytesRef term;
                if (doc < this.lastDocID) {
                    throw new IllegalArgumentException("docs were sent out-of-order: lastDocID=" + this.lastDocID + " vs docID=" + doc);
                }
                this.lastDocID = doc;
                int curDocID = terms.docID();
                if (doc > curDocID) {
                    curDocID = terms.advance(doc);
                }
                if (doc == curDocID && termsEnum.seekExact(term = terms.lookupOrd(terms.ordValue()))) {
                    return termsEnum.docFreq();
                }
                return 0;
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (o.getClass() != JoinDocFreqValueSource.class) {
            return false;
        }
        JoinDocFreqValueSource other = (JoinDocFreqValueSource)o;
        if (!this.qfield.equals(other.qfield)) {
            return false;
        }
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        return this.qfield.hashCode() + super.hashCode();
    }
}

