/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.extensions;

import guideme.document.block.LytSlotGrid;
import guideme.document.block.recipes.LytStandardRecipeBox;
import guideme.internal.GuidebookText;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.item.crafting.SmithingTrimRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class VanillaRecipes {
    private static final Logger LOG = LoggerFactory.getLogger(VanillaRecipes.class);

    private VanillaRecipes() {
    }

    public static LytStandardRecipeBox<CraftingRecipe> createCrafting(RecipeHolder<CraftingRecipe> holder) {
        LytSlotGrid grid;
        CraftingRecipe recipe = (CraftingRecipe)holder.value();
        NonNullList ingredients = recipe.getIngredients();
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
            grid = new LytSlotGrid(shapedRecipe.getWidth(), shapedRecipe.getHeight());
            for (int x = 0; x < shapedRecipe.getWidth(); ++x) {
                for (int y = 0; y < shapedRecipe.getHeight(); ++y) {
                    Ingredient ingredient;
                    int index = y * shapedRecipe.getWidth() + x;
                    if (index >= ingredients.size() || (ingredient = (Ingredient)ingredients.get(index)).isEmpty()) continue;
                    grid.setIngredient(x, y, ingredient);
                }
            }
        } else {
            int ingredientCount = ingredients.size();
            grid = new LytSlotGrid(Math.min(3, ingredientCount), (ingredientCount + 2) / 3);
            for (int i = 0; i < ingredients.size(); ++i) {
                int col = i % 3;
                int row = i / 3;
                grid.setIngredient(col, row, (Ingredient)ingredients.get(i));
            }
        }
        String title = recipe instanceof ShapedRecipe ? GuidebookText.Crafting.text().getString() : GuidebookText.ShapelessCrafting.text().getString();
        return LytStandardRecipeBox.builder().title(title).icon((ItemLike)Blocks.CRAFTING_TABLE).input(grid).outputFromResultOf(holder).build(holder);
    }

    public static LytStandardRecipeBox<SmeltingRecipe> createSmelting(RecipeHolder<SmeltingRecipe> recipe) {
        return LytStandardRecipeBox.builder().title(GuidebookText.Smelting.text().getString()).icon((ItemLike)Blocks.FURNACE).input(LytSlotGrid.row((List<Ingredient>)((SmeltingRecipe)recipe.value()).getIngredients(), true)).outputFromResultOf(recipe).build(recipe);
    }

    public static LytStandardRecipeBox<BlastingRecipe> createBlasting(RecipeHolder<BlastingRecipe> recipe) {
        return LytStandardRecipeBox.builder().title(GuidebookText.Blasting.text().getString()).icon((ItemLike)Blocks.BLAST_FURNACE).input(LytSlotGrid.row((List<Ingredient>)((BlastingRecipe)recipe.value()).getIngredients(), true)).outputFromResultOf(recipe).build(recipe);
    }

    public static LytStandardRecipeBox<SmithingRecipe> createSmithing(RecipeHolder<SmithingRecipe> holder) {
        return LytStandardRecipeBox.builder().icon((ItemLike)Blocks.SMITHING_TABLE).title(Items.SMITHING_TABLE.getDescription().getString()).input(LytSlotGrid.row(VanillaRecipes.getSmithingIngredients((SmithingRecipe)holder.value()), true)).outputFromResultOf(holder).build(holder);
    }

    private static List<Ingredient> getSmithingIngredients(SmithingRecipe recipe) {
        if (recipe instanceof SmithingTrimRecipe) {
            SmithingTrimRecipe trimRecipe = (SmithingTrimRecipe)recipe;
            return List.of(trimRecipe.template, trimRecipe.base, trimRecipe.addition);
        }
        if (recipe instanceof SmithingTransformRecipe) {
            SmithingTransformRecipe transformRecipe = (SmithingTransformRecipe)recipe;
            return List.of(transformRecipe.template, transformRecipe.base, transformRecipe.addition);
        }
        LOG.warn("Cannot determine ingredients of smithing recipe type {}", (Object)recipe.getClass());
        return List.of();
    }
}

