/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.entity;

import com.stal111.forbidden_arcanus.ForbiddenArcanus;
import com.stal111.forbidden_arcanus.common.entity.CustomBoat;
import com.stal111.forbidden_arcanus.core.init.ModEntities;
import com.stal111.forbidden_arcanus.core.init.ModItems;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ModBoat
extends Boat
implements CustomBoat {
    private static final EntityDataAccessor<Integer> DATA_ID_WOOD_TYPE = SynchedEntityData.defineId(ModBoat.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public ModBoat(EntityType<? extends Boat> entityType, Level level) {
        super(entityType, level);
    }

    public ModBoat(Level level, double x, double y, double z) {
        this((EntityType<? extends Boat>)((EntityType)ModEntities.BOAT.get()), level);
        this.setPos(x, y, z);
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ID_WOOD_TYPE, (Object)0);
    }

    protected void readAdditionalSaveData(@Nonnull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("Type", 8)) {
            this.setWoodType(Type.byName(tag.getString("Type")));
        }
    }

    protected void addAdditionalSaveData(@Nonnull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putString("Type", this.getWoodType().getSerializedName());
    }

    @Nonnull
    public Item getDropItem() {
        return (Item)this.getWoodType().getBoatItem().get();
    }

    @Override
    public Type getWoodType() {
        return Type.byId((Integer)this.entityData.get(DATA_ID_WOOD_TYPE));
    }

    @Override
    public void setWoodType(Type type) {
        this.entityData.set(DATA_ID_WOOD_TYPE, (Object)type.ordinal());
    }

    @Nonnull
    protected Component getTypeName() {
        return EntityType.BOAT.getDescription();
    }

    public static enum Type implements StringRepresentable
    {
        AURUM("aurum", (Supplier<BoatItem>)ModItems.AURUM_BOAT, (Supplier<BoatItem>)ModItems.AURUM_CHEST_BOAT),
        EDELWOOD("edelwood", (Supplier<BoatItem>)ModItems.EDELWOOD_BOAT, (Supplier<BoatItem>)ModItems.EDELWOOD_CHEST_BOAT);

        private final String name;
        private final Supplier<BoatItem> boatItem;
        private final Supplier<BoatItem> chestBoatItem;

        private Type(String name, Supplier<BoatItem> boatItem, Supplier<BoatItem> chestBoatItem) {
            this.name = name;
            this.boatItem = boatItem;
            this.chestBoatItem = chestBoatItem;
        }

        @Nonnull
        public String getSerializedName() {
            return this.name;
        }

        public Supplier<BoatItem> getBoatItem() {
            return this.boatItem;
        }

        public Supplier<BoatItem> getChestBoatItem() {
            return this.chestBoatItem;
        }

        public ResourceLocation getTexture(boolean hasChest) {
            if (hasChest) {
                return ForbiddenArcanus.location("textures/entity/chest_boat/" + this.name + ".png");
            }
            return ForbiddenArcanus.location("textures/entity/boat/" + this.name + ".png");
        }

        public String getModelLocation() {
            return "boat/" + this.name;
        }

        public String getChestModelLocation() {
            return "chest_boat/" + this.name;
        }

        public static Type byId(int id) {
            Type[] values = Type.values();
            if (id < 0 || id >= values.length) {
                id = 0;
            }
            return values[id];
        }

        public static Type byName(String name) {
            Type[] values;
            for (Type value : values = Type.values()) {
                if (!value.getSerializedName().equals(name)) continue;
                return value;
            }
            return values[0];
        }
    }
}

