/*
 * Decompiled with CFR 0.152.
 */
package amp_libs.org.apache.hc.client5.http.impl.classic;

import amp_libs.org.apache.hc.client5.http.HttpRoute;
import amp_libs.org.apache.hc.client5.http.classic.BackoffManager;
import amp_libs.org.apache.hc.client5.http.classic.ConnectionBackoffStrategy;
import amp_libs.org.apache.hc.client5.http.classic.ExecChain;
import amp_libs.org.apache.hc.client5.http.classic.ExecChainHandler;
import amp_libs.org.apache.hc.core5.annotation.Contract;
import amp_libs.org.apache.hc.core5.annotation.ThreadingBehavior;
import amp_libs.org.apache.hc.core5.http.ClassicHttpRequest;
import amp_libs.org.apache.hc.core5.http.ClassicHttpResponse;
import amp_libs.org.apache.hc.core5.http.HttpException;
import amp_libs.org.apache.hc.core5.util.Args;
import amp_libs.org.slf4j.Logger;
import amp_libs.org.slf4j.LoggerFactory;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.STATELESS)
public final class BackoffStrategyExec
implements ExecChainHandler {
    private static final Logger LOG = LoggerFactory.getLogger(BackoffStrategyExec.class);
    private final ConnectionBackoffStrategy connectionBackoffStrategy;
    private final BackoffManager backoffManager;

    public BackoffStrategyExec(ConnectionBackoffStrategy connectionBackoffStrategy, BackoffManager backoffManager) {
        Args.notNull(connectionBackoffStrategy, "Connection backoff strategy");
        Args.notNull(backoffManager, "Backoff manager");
        this.connectionBackoffStrategy = connectionBackoffStrategy;
        this.backoffManager = backoffManager;
    }

    @Override
    public ClassicHttpResponse execute(ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws IOException, HttpException {
        ClassicHttpResponse response;
        Args.notNull(request, "HTTP request");
        Args.notNull(scope, "Scope");
        HttpRoute route = scope.route;
        try {
            response = chain.proceed(request, scope);
        }
        catch (HttpException | IOException ex) {
            if (this.connectionBackoffStrategy.shouldBackoff(ex)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Backing off route {} due to exception: {}", (Object)route, (Object)ex.getMessage());
                }
                this.backoffManager.backOff(route);
            }
            throw ex;
        }
        if (this.connectionBackoffStrategy.shouldBackoff(response)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Backing off route {} due to response status: {}", (Object)route, (Object)response.getCode());
            }
            this.backoffManager.backOff(route);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Probing route: {}", (Object)route);
            }
            this.backoffManager.probe(route);
        }
        return response;
    }
}

