/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.baguettelib.event.entity;

import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.ICancellableEvent;

public abstract class CreativeFlightEvent
extends Event {
    protected final Player player;

    protected CreativeFlightEvent(Player player) {
        this.player = player;
    }

    public Player getPlayer() {
        return this.player;
    }

    public static class Changed
    extends CreativeFlightEvent {
        private final boolean previousFlightState;
        private final boolean newFlightState;

        public Changed(Player player, boolean previousFlightState, boolean newFlightState) {
            super(player);
            this.previousFlightState = previousFlightState;
            this.newFlightState = newFlightState;
        }

        public boolean getPreviousFlightState() {
            return this.previousFlightState;
        }

        public boolean getNewFlightState() {
            return this.newFlightState;
        }

        public boolean wasFlightEnabled() {
            return !this.previousFlightState && this.newFlightState;
        }

        public boolean wasFlightDisabled() {
            return this.previousFlightState && !this.newFlightState;
        }
    }

    public static class Toggle
    extends CreativeFlightEvent
    implements ICancellableEvent {
        private boolean flightState;

        public Toggle(Player player, boolean flightState) {
            super(player);
            this.flightState = flightState;
        }

        public boolean getFlightState() {
            return this.flightState;
        }

        public void setFlightState(boolean flightState) {
            this.flightState = flightState;
        }

        public boolean isEnablingFlight() {
            return this.flightState;
        }

        public boolean isDisablingFlight() {
            return !this.flightState;
        }
    }
}

