/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.util;

import com.klikli_dev.occultism.common.item.otherworld.OtherworldBlockItem;
import com.klikli_dev.occultism.registry.OccultismDataComponents;
import com.klikli_dev.occultism.registry.OccultismEffects;
import net.minecraft.client.Minecraft;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.util.thread.SidedThreadGroups;

public class OtherworldUtil {
    public static String getTranslationKeyDistAware(OtherworldBlockItem item, ItemStack stack) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            return OtherworldUtil.getClientTranslationKey(item, stack);
        }
        return item.getOrCreateDescriptionId();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getClientTranslationKey(OtherworldBlockItem item, ItemStack stack) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            return item.getOrCreateDescriptionId();
        }
        boolean thirdEye = Minecraft.getInstance() != null && Minecraft.getInstance().player != null && Minecraft.getInstance().player.hasEffect(OccultismEffects.THIRD_EYE);
        return (Boolean)stack.getOrDefault(OccultismDataComponents.IS_INVENTORY_ITEM, (Object)false) != false || thirdEye ? item.getOrCreateDescriptionId() : item.getDescriptionId();
    }
}

