/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.crafting.recipe;

import com.klikli_dev.modonomicon.api.ModonomiconAPI;
import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.klikli_dev.occultism.common.ritual.Ritual;
import com.klikli_dev.occultism.common.ritual.RitualFactory;
import com.klikli_dev.occultism.registry.OccultismRecipes;
import com.klikli_dev.occultism.registry.OccultismRituals;
import com.klikli_dev.occultism.util.OccultismExtraStreamCodecs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.conditions.ICondition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RitualRecipe
implements Recipe<SingleRecipeInput> {
    public static final int DEFAULT_DURATION = 30;
    public static final MapCodec<RitualRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("ritual_type").forGetter(r -> r.ritualType), (App)RitualRequirementSettings.CODEC.forGetter(r -> r.ritualRequirementSettings), (App)RitualStartSettings.CODEC.forGetter(r -> r.ritualStartSettings), (App)EntityToSummonSettings.CODEC.forGetter(r -> r.entityToSummonSettings), (App)ItemStack.STRICT_CODEC.fieldOf("ritual_dummy").forGetter(r -> r.ritualDummy), (App)ItemStack.OPTIONAL_CODEC.fieldOf("result").forGetter(r -> r.result), (App)Codec.STRING.optionalFieldOf("command").forGetter(r -> Optional.ofNullable(r.command))).apply((Applicative)instance, (ritualType, ritualRequirementSettings, ritualStartSettings, entityToSummonSettings, ritualDummy, result, command) -> new RitualRecipe((ResourceLocation)ritualType, (RitualRequirementSettings)ritualRequirementSettings, (RitualStartSettings)ritualStartSettings, (EntityToSummonSettings)entityToSummonSettings, (ItemStack)ritualDummy, (ItemStack)result, command.orElse(null))));
    public static final StreamCodec<RegistryFriendlyByteBuf, RitualRecipe> STREAM_CODEC = OccultismExtraStreamCodecs.composite(ResourceLocation.STREAM_CODEC, r -> r.ritualType, RitualRequirementSettings.STREAM_CODEC, r -> r.ritualRequirementSettings, RitualStartSettings.STREAM_CODEC, r -> r.ritualStartSettings, EntityToSummonSettings.STREAM_CODEC, r -> r.entityToSummonSettings, ItemStack.STREAM_CODEC, r -> r.ritualDummy, ItemStack.OPTIONAL_STREAM_CODEC, r -> r.result, ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.STRING_UTF8), r -> Optional.ofNullable(r.command), (ritualType, ritualRequirementSettings, ritualStartSettings, entityToSummonSettings, ritualDummy, result, command) -> new RitualRecipe((ResourceLocation)ritualType, (RitualRequirementSettings)ritualRequirementSettings, (RitualStartSettings)ritualStartSettings, (EntityToSummonSettings)entityToSummonSettings, (ItemStack)ritualDummy, (ItemStack)result, command.orElse(null)));
    public static Serializer SERIALIZER = new Serializer();
    private final ResourceLocation ritualType;
    private final RitualRequirementSettings ritualRequirementSettings;
    private final RitualStartSettings ritualStartSettings;
    @Nullable
    private final EntityToSummonSettings entityToSummonSettings;
    private final ItemStack ritualDummy;
    private final ItemStack result;
    @Nullable
    private final Supplier<Ritual> ritual;
    @Nullable
    private final String command;

    public RitualRecipe(ResourceLocation ritualType, RitualRequirementSettings ritualRequirementSettings, RitualStartSettings ritualStartSettings, @Nullable EntityToSummonSettings entityToSummonSettings, ItemStack ritualDummy, ItemStack result, String command) {
        this.ritualType = ritualType;
        this.ritualRequirementSettings = ritualRequirementSettings;
        this.ritualStartSettings = ritualStartSettings;
        this.entityToSummonSettings = entityToSummonSettings != null ? entityToSummonSettings : new EntityToSummonSettings(null, null, null, null, -1, 1);
        this.ritualDummy = ritualDummy;
        this.result = result;
        this.ritual = () -> ((RitualFactory)OccultismRituals.REGISTRY.get(this.ritualType)).create(this);
        this.command = command;
    }

    public RitualRecipe(ResourceLocation pentacleId, ResourceLocation ritualType, ItemStack ritualDummy, ItemStack result, @Nullable EntityType<?> entityToSummon, @Nullable TagKey<EntityType<?>> entityTagToSummon, @Nullable CompoundTag entityNbt, Ingredient activationItem, NonNullList<Ingredient> ingredients, int duration, int spiritMaxAge, int summonNumber, @Nullable ResourceLocation spiritJobType, @Nullable EntityToSacrifice entityToSacrifice, @Nullable Ingredient itemToUse, @Nullable String command) {
        this(ritualType, new RitualRequirementSettings(pentacleId, ingredients, activationItem, duration, (float)duration / (float)(ingredients.size() + 1)), new RitualStartSettings(entityToSacrifice, itemToUse, null), (EntityToSummonSettings)(entityTagToSummon == null && entityToSummon == null ? null : new EntityToSummonSettings(entityToSummon, entityTagToSummon, entityNbt, spiritJobType, spiritMaxAge, summonNumber)), ritualDummy, result, command);
    }

    public boolean isSpecial() {
        return true;
    }

    @Nullable
    public ICondition getCondition() {
        return this.ritualStartSettings.condition();
    }

    @Nullable
    public String getCommand() {
        return this.command;
    }

    @Nullable
    public CompoundTag getEntityNbt() {
        return this.entityToSummonSettings.entityNbt();
    }

    public ResourceLocation getPentacleId() {
        return this.ritualRequirementSettings.pentacleId();
    }

    public Multiblock getPentacle() {
        return ModonomiconAPI.get().getMultiblock(this.ritualRequirementSettings.pentacleId());
    }

    public ItemStack getRitualDummy() {
        return this.ritualDummy;
    }

    public Ingredient getActivationItem() {
        return this.ritualRequirementSettings.activationItem();
    }

    public ItemStack[] getActivationItemStack() {
        return this.ritualRequirementSettings.activationItem.getItems();
    }

    public int getDuration() {
        return this.ritualRequirementSettings.duration();
    }

    public float getDurationPerIngredient() {
        return this.ritualRequirementSettings.durationPerIngredient();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    public boolean matches(@NotNull SingleRecipeInput pInv, @NotNull Level pLevel) {
        return false;
    }

    @NotNull
    public ItemStack assemble(@NotNull SingleRecipeInput pCraftingContainer, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        return this.result;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return this.ritualRequirementSettings.ingredients();
    }

    public boolean matches(Level level, BlockPos goldenBowlPosition, ItemStack activationItem) {
        return this.ritual.get().identify(level, goldenBowlPosition, activationItem);
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)OccultismRecipes.RITUAL_TYPE.get();
    }

    public TagKey<EntityType<?>> getEntityToSacrifice() {
        return this.ritualStartSettings.entityToSacrifice().tag();
    }

    public boolean requiresSacrifice() {
        return this.ritualStartSettings.requiresSacrifice();
    }

    @Nullable
    public Ingredient getItemToUse() {
        return this.ritualStartSettings.itemToUse();
    }

    public boolean requiresItemUse() {
        return this.ritualStartSettings.requiresItemUse();
    }

    @Nullable
    public EntityType<?> getEntityToSummon() {
        return this.entityToSummonSettings.entityToSummon();
    }

    @Nullable
    public TagKey<EntityType<?>> getEntityTagToSummon() {
        return this.entityToSummonSettings.entityTagToSummon();
    }

    public ResourceLocation getRitualType() {
        return this.ritualType;
    }

    public Ritual getRitual() {
        return this.ritual.get();
    }

    public String getEntityToSacrificeDisplayName() {
        return this.ritualStartSettings.getEntityToSacrificeDisplayName();
    }

    @Nullable
    public ResourceLocation getSpiritJobType() {
        return this.entityToSummonSettings.spiritJobType();
    }

    public int getSpiritMaxAge() {
        return this.entityToSummonSettings.spiritMaxAge();
    }

    public int getSummonNumber() {
        return this.entityToSummonSettings.summonNumber();
    }

    public record RitualRequirementSettings(ResourceLocation pentacleId, NonNullList<Ingredient> ingredients, Ingredient activationItem, int duration, float durationPerIngredient) {
        public static MapCodec<RitualRequirementSettings> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("pentacle_id").forGetter(r -> r.pentacleId), (App)Ingredient.LIST_CODEC.fieldOf("ingredients").forGetter(r -> r.ingredients), (App)Ingredient.CODEC.fieldOf("activation_item").forGetter(r -> r.activationItem), (App)Codec.INT.optionalFieldOf("duration", (Object)30).forGetter(r -> r.duration)).apply((Applicative)instance, (pentacleId, ingredients, activationItem, duration) -> new RitualRequirementSettings((ResourceLocation)pentacleId, (NonNullList<Ingredient>)NonNullList.copyOf((Collection)ingredients), (Ingredient)activationItem, (int)duration, -1.0f)));
        public static StreamCodec<RegistryFriendlyByteBuf, RitualRequirementSettings> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, r -> r.pentacleId, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), r -> r.ingredients, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, r -> r.activationItem, (StreamCodec)ByteBufCodecs.INT, r -> r.duration, (StreamCodec)ByteBufCodecs.FLOAT, r -> Float.valueOf(r.durationPerIngredient), (pentacleId, ingredients, activationItem, duration, durationPerIngredient) -> new RitualRequirementSettings((ResourceLocation)pentacleId, (NonNullList<Ingredient>)NonNullList.copyOf((Collection)ingredients), (Ingredient)activationItem, (int)duration, durationPerIngredient.floatValue()));

        public RitualRequirementSettings(ResourceLocation pentacleId, NonNullList<Ingredient> ingredients, Ingredient activationItem, int duration, float durationPerIngredient) {
            this.pentacleId = pentacleId;
            this.ingredients = ingredients;
            this.activationItem = activationItem;
            this.duration = duration;
            this.durationPerIngredient = durationPerIngredient == -1.0f ? (float)duration / (float)(ingredients.size() + 1) : durationPerIngredient;
        }
    }

    public record RitualStartSettings(@Nullable EntityToSacrifice entityToSacrifice, @Nullable Ingredient itemToUse, @Nullable ICondition condition) {
        public static MapCodec<RitualStartSettings> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)EntityToSacrifice.CODEC.codec().optionalFieldOf("entity_to_sacrifice").forGetter(r -> Optional.ofNullable(r.entityToSacrifice)), (App)Ingredient.CODEC.optionalFieldOf("item_to_use").forGetter(r -> Optional.ofNullable(r.itemToUse)), (App)ICondition.CODEC.optionalFieldOf("condition").forGetter(r -> Optional.ofNullable(r.condition))).apply((Applicative)instance, (entityToSacrifice, itemToUse, condition) -> new RitualStartSettings(entityToSacrifice.orElse(null), itemToUse.orElse(null), condition.orElse(null))));
        public static StreamCodec<RegistryFriendlyByteBuf, RitualStartSettings> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional(EntityToSacrifice.STREAM_CODEC), r -> Optional.ofNullable(r.entityToSacrifice), (StreamCodec)ByteBufCodecs.optional((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC), r -> Optional.ofNullable(r.itemToUse), (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.fromCodecWithRegistries((Codec)ICondition.CODEC)), r -> Optional.ofNullable(r.condition), (entityToSacrifice, itemToUse, condition) -> new RitualStartSettings(entityToSacrifice.orElse(null), itemToUse.orElse(null), condition.orElse(null)));

        public String getEntityToSacrificeDisplayName() {
            return this.entityToSacrifice != null ? this.entityToSacrifice.displayName() : "";
        }

        public boolean requiresItemUse() {
            return this.itemToUse != null && !this.itemToUse.isEmpty();
        }

        public boolean requiresSacrifice() {
            return this.entityToSacrifice != null;
        }
    }

    public record EntityToSummonSettings(@Nullable EntityType<?> entityToSummon, @Nullable TagKey<EntityType<?>> entityTagToSummon, @Nullable CompoundTag entityNbt, @Nullable ResourceLocation spiritJobType, int spiritMaxAge, int summonNumber) {
        public static MapCodec<EntityToSummonSettings> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.ENTITY_TYPE.byNameCodec().optionalFieldOf("entity_to_summon").forGetter(r -> Optional.ofNullable(r.entityToSummon)), (App)TagKey.codec((ResourceKey)Registries.ENTITY_TYPE).optionalFieldOf("entity_tag_to_summon").forGetter(r -> Optional.ofNullable(r.entityTagToSummon)), (App)CompoundTag.CODEC.optionalFieldOf("entity_nbt").forGetter(r -> Optional.ofNullable(r.entityNbt)), (App)ResourceLocation.CODEC.optionalFieldOf("spirit_job_type").forGetter(r -> Optional.ofNullable(r.spiritJobType)), (App)Codec.INT.optionalFieldOf("spirit_max_age", (Object)-1).forGetter(r -> r.spiritMaxAge), (App)Codec.INT.optionalFieldOf("summon_number", (Object)1).forGetter(r -> r.summonNumber)).apply((Applicative)instance, (entityToSummon, entityTagToSummon, entityNbt, spiritJobType, spiritMaxAge, summonNumber) -> new EntityToSummonSettings(entityToSummon.orElse(null), entityTagToSummon.orElse(null), entityNbt.orElse(null), spiritJobType.orElse(null), (int)spiritMaxAge, (int)summonNumber)));
        public static StreamCodec<RegistryFriendlyByteBuf, EntityToSummonSettings> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.ENTITY_TYPE)), r -> Optional.ofNullable(r.entityToSummon), (StreamCodec)ByteBufCodecs.optional(OccultismExtraStreamCodecs.tagKey(Registries.ENTITY_TYPE)), r -> Optional.ofNullable(r.entityTagToSummon), (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.COMPOUND_TAG), r -> Optional.ofNullable(r.entityNbt), (StreamCodec)ByteBufCodecs.optional((StreamCodec)ResourceLocation.STREAM_CODEC), r -> Optional.ofNullable(r.spiritJobType), (StreamCodec)ByteBufCodecs.INT, r -> r.spiritMaxAge, (StreamCodec)ByteBufCodecs.INT, r -> r.summonNumber, (entityToSummon, entityTagToSummon, entityNbt, spiritJobType, spiritMaxAge, summonNumber) -> new EntityToSummonSettings(entityToSummon.orElse(null), entityTagToSummon.orElse(null), entityNbt.orElse(null), spiritJobType.orElse(null), (int)spiritMaxAge, (int)summonNumber));
    }

    public record EntityToSacrifice(TagKey<EntityType<?>> tag, String displayName) {
        public static MapCodec<EntityToSacrifice> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TagKey.codec((ResourceKey)Registries.ENTITY_TYPE).fieldOf("tag").forGetter(EntityToSacrifice::tag), (App)Codec.STRING.fieldOf("display_name").forGetter(EntityToSacrifice::displayName)).apply((Applicative)instance, EntityToSacrifice::new));
        public static StreamCodec<RegistryFriendlyByteBuf, EntityToSacrifice> STREAM_CODEC = StreamCodec.composite(OccultismExtraStreamCodecs.tagKey(Registries.ENTITY_TYPE), r -> r.tag, (StreamCodec)ByteBufCodecs.STRING_UTF8, r -> r.displayName, EntityToSacrifice::new);
    }

    public static class Serializer
    implements RecipeSerializer<RitualRecipe> {
        @NotNull
        public MapCodec<RitualRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, RitualRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

