/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.item.spirit;

import com.klikli_dev.occultism.api.common.data.MachineReference;
import com.klikli_dev.occultism.client.gui.GuiHelper;
import com.klikli_dev.occultism.common.entity.job.ManageMachineJob;
import com.klikli_dev.occultism.common.entity.job.SpiritJob;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.common.item.spirit.BookOfCallingItem;
import com.klikli_dev.occultism.common.item.spirit.calling.ItemMode;
import com.klikli_dev.occultism.common.item.spirit.calling.ItemModes;
import com.klikli_dev.occultism.util.BlockEntityUtil;
import com.klikli_dev.occultism.util.EntityUtil;
import com.klikli_dev.occultism.util.ItemNBTUtil;
import com.klikli_dev.occultism.util.TextUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;

public class BookOfCallingManageMachineItem
extends BookOfCallingItem {
    public BookOfCallingManageMachineItem(Item.Properties properties, String translationKeyBase) {
        super(properties, translationKeyBase, spirit -> spirit.getJob().orElse(null) instanceof ManageMachineJob);
    }

    @Override
    public InteractionResult handleItemMode(Player player, Level world, BlockPos pos, ItemStack stack, Direction facing) {
        MachineReference machine;
        ItemMode itemMode = this.getCurrentItemMode(stack);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (!world.isClientSide) {
            if (itemMode == ItemModes.SET_EXTRACT && blockEntity != null && world.getCapability(Capabilities.ItemHandler.BLOCK, blockEntity.getBlockPos(), blockEntity.getBlockState(), blockEntity, (Object)facing) != null) {
                return this.setSpiritManagedMachineExtractLocation(player, world, pos, stack, facing) ? InteractionResult.SUCCESS : InteractionResult.PASS;
            }
        } else if (Objects.requireNonNull(itemMode) == ItemModes.SET_MANAGED_MACHINE && blockEntity != null && BlockEntityUtil.hasCapabilityOnAnySide(blockEntity, Capabilities.ItemHandler.BLOCK) && (machine = ItemNBTUtil.getManagedMachine(stack)) != null) {
            GuiHelper.openBookOfCallingManagedMachineGui(machine.insertFacing, machine.extractFacing, machine.customName);
        }
        return super.handleItemMode(player, world, pos, stack, facing);
    }

    public boolean setSpiritManagedMachineExtractLocation(Player player, Level world, BlockPos pos, ItemStack stack, Direction face) {
        UUID boundSpiritId = ItemNBTUtil.getSpiritEntityUUID(stack);
        if (boundSpiritId != null) {
            Optional<SpiritEntity> boundSpirit = EntityUtil.getEntityByUuiDGlobal(world.getServer(), boundSpiritId).map(e -> (SpiritEntity)e);
            BlockEntity extractBlockEntity = world.getBlockEntity(pos);
            if (boundSpirit.isPresent() && extractBlockEntity != null) {
                SpiritJob spiritJob;
                if (boundSpirit.get().getJob().isPresent() && (spiritJob = boundSpirit.get().getJob().get()) instanceof ManageMachineJob) {
                    ManageMachineJob manageMachine = (ManageMachineJob)spiritJob;
                    if (manageMachine.getManagedMachine() == null) {
                        player.displayClientMessage((Component)Component.translatable((String)"item.occultism.book_of_calling.message_set_managed_machine_extract_location", (Object[])new Object[]{TextUtil.formatDemonName(boundSpirit.get().getName().getString())}), true);
                        return true;
                    }
                    BlockEntity oldManagedMachineBlockEntity = manageMachine.getManagedMachineBlockEntity();
                    MachineReference newReference = MachineReference.from(extractBlockEntity, oldManagedMachineBlockEntity != null ? oldManagedMachineBlockEntity : extractBlockEntity);
                    newReference.extractFacing = face;
                    if (manageMachine.getManagedMachine() == null || !manageMachine.getManagedMachine().extractGlobalPos.equals(newReference.extractGlobalPos)) {
                        manageMachine.setManagedMachine(newReference);
                    } else {
                        manageMachine.getManagedMachine().extractRegistryName = newReference.extractRegistryName;
                        manageMachine.getManagedMachine().extractFacing = newReference.extractFacing;
                    }
                    ItemNBTUtil.updateItemNBTFromEntity(stack, boundSpirit.get());
                    String blockName = world.getBlockState(pos).getBlock().getDescriptionId();
                    player.displayClientMessage((Component)Component.translatable((String)"item.occultism.book_of_calling.message_set_managed_machine_extract_location", (Object[])new Object[]{TextUtil.formatDemonName(boundSpirit.get().getName().getString()), Component.translatable((String)blockName), face.getSerializedName()}), true);
                    return true;
                }
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"item.occultism.book_of_calling.message_spirit_not_found"), true);
            }
        }
        return false;
    }

    @Override
    public List<ItemMode> getItemModes() {
        return Arrays.asList(ItemModes.SET_MANAGED_MACHINE, ItemModes.SET_EXTRACT, ItemModes.SET_STORAGE_CONTROLLER);
    }
}

