/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.possessed.horde;

import com.klikli_dev.occultism.common.entity.possessed.PossessedMob;
import com.klikli_dev.occultism.common.entity.possessed.horde.PossessedStrongBreezeEntity;
import com.klikli_dev.occultism.registry.OccultismTags;
import java.util.Optional;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.level.Level;

public class WildSlimeEntity
extends Slime
implements PossessedMob {
    protected Optional<PossessedStrongBreezeEntity> master = Optional.empty();

    public WildSlimeEntity(EntityType<? extends WildSlimeEntity> type, Level world) {
        super(type, world);
    }

    public void setSize(int size, boolean resetHealth) {
        super.setSize(size, resetHealth);
        this.xpReward = size - 1;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH);
    }

    public void setMaster(PossessedStrongBreezeEntity master) {
        this.master = Optional.ofNullable(master);
    }

    public void remove(Entity.RemovalReason reason) {
        this.master.ifPresent(boss -> boss.notifyMinionDeath(this));
        super.remove(reason);
    }

    public boolean isInvulnerableTo(DamageSource source) {
        TagKey<EntityType<?>> wildTrialTag = OccultismTags.Entities.WILD_TRIAL;
        Entity trueSource = source.getEntity();
        if (trueSource != null && trueSource.getType().is(wildTrialTag)) {
            return true;
        }
        Entity immediateSource = source.getDirectEntity();
        if (immediateSource != null && immediateSource.getType().is(wildTrialTag)) {
            return true;
        }
        return super.isInvulnerableTo(source);
    }

    protected float getSoundVolume() {
        return 0.1f * (float)this.getSize();
    }

    protected boolean shouldDespawnInPeaceful() {
        return true;
    }

    @Override
    public EntityType basedMob() {
        return EntityType.SLIME;
    }
}

