/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.content.block.mechanical_pulverizer;

import com.klikli_dev.occultism.crafting.recipe.CrushingRecipe;
import com.klikli_dev.occultism.crafting.recipe.TieredSingleRecipeInput;
import com.klikli_dev.occultism.registry.OccultismRecipes;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.sound.SoundScapes;
import io.github.irishgreencitrus.occultengineering.content.block.mechanical_pulverizer.PulverizerBlock;
import io.github.irishgreencitrus.occultengineering.registry.OccultEngineeringBlockEntities;
import java.util.Optional;
import java.util.function.Supplier;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;

public class PulverizerBlockEntity
extends KineticBlockEntity {
    public ItemStackHandler inputInv = new ItemStackHandler(1);
    public ItemStackHandler outputInv = new ItemStackHandler(1);
    public IItemHandler capability = new PulverizerInventoryHandler();
    public int timer;
    public Supplier<Integer> tier = () -> 1;
    private RecipeHolder<CrushingRecipe> lastRecipe;

    public PulverizerBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)OccultEngineeringBlockEntities.MECHANICAL_PULVERIZER.get(), (be, context) -> be.capability);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickAudio() {
        super.tickAudio();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (this.inputInv.getStackInSlot(0).isEmpty()) {
            return;
        }
        float pitch = Mth.clamp((float)(Math.abs(this.getSpeed()) / 256.0f + 0.45f), (float)0.85f, (float)1.0f);
        SoundScapes.play((SoundScapes.AmbienceGroup)SoundScapes.AmbienceGroup.CRUSHING, (BlockPos)this.worldPosition, (float)pitch);
    }

    public void tick() {
        super.tick();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (this.outputInv.getStackInSlot(0).getCount() == this.outputInv.getStackInSlot(0).getMaxStackSize()) {
            return;
        }
        if (this.level == null) {
            return;
        }
        if (this.timer <= 0) {
            if (this.inputInv.getStackInSlot(0).isEmpty()) {
                return;
            }
            Optional<RecipeHolder<CrushingRecipe>> recipe = this.findCurrentRecipe(this.inputInv.getStackInSlot(0));
            this.timer = recipe.map(crushingRecipeRecipeHolder -> ((CrushingRecipe)crushingRecipeRecipeHolder.value()).getCrushingTime()).orElse(100);
            this.notifyUpdate();
        } else {
            this.timer -= this.getProcessingSpeed();
            if (this.level.isClientSide) {
                this.spawnParticles();
                return;
            }
            if (this.timer <= 0) {
                this.process();
                this.notifyUpdate();
            }
        }
    }

    public void invalidate() {
        super.invalidate();
        this.invalidateCapabilities();
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((Level)this.level, (BlockPos)this.worldPosition, (IItemHandler)this.inputInv);
        ItemHelper.dropContents((Level)this.level, (BlockPos)this.worldPosition, (IItemHandler)this.outputInv);
    }

    public int getProcessingSpeed() {
        return Mth.clamp((int)((int)Math.abs(this.getSpeed() / 16.0f)), (int)1, (int)512);
    }

    private void process() {
        if (this.level == null) {
            return;
        }
        ItemStack inputStack = this.inputInv.getStackInSlot(0);
        Optional<RecipeHolder<CrushingRecipe>> recipe = this.findCurrentRecipe(inputStack);
        if (recipe.isEmpty()) {
            return;
        }
        TieredSingleRecipeInput input = new TieredSingleRecipeInput(inputStack, this.tier.get().intValue());
        ItemStack result = ((CrushingRecipe)recipe.get().value()).assemble((RecipeInput)input, (HolderLookup.Provider)this.level.registryAccess());
        ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)this.outputInv, (ItemStack)result, (boolean)true);
        if (!remainder.isEmpty()) {
            return;
        }
        inputStack.shrink(1);
        this.inputInv.setStackInSlot(0, inputStack);
        ItemHandlerHelper.insertItem((IItemHandler)this.outputInv, (ItemStack)result, (boolean)false);
    }

    private void spawnParticles() {
        if (this.level == null) {
            return;
        }
        if (this.level.random.nextInt(3) != 0) {
            return;
        }
        ItemStack item = this.inputInv.getStackInSlot(0);
        if (item.isEmpty()) {
            return;
        }
        ItemParticleOption data = new ItemParticleOption(ParticleTypes.ITEM, item);
        float yRot = -((Direction)this.getBlockState().getValue(PulverizerBlock.HORIZONTAL_FACING)).toYRot();
        Vec3 center = this.worldPosition.getCenter();
        Vec3 offset = VecHelper.rotate((Vec3)new Vec3(0.0, 0.0, 0.5), (double)yRot, (Direction.Axis)Direction.Axis.Y);
        offset = VecHelper.offsetRandomly((Vec3)offset, (RandomSource)this.level.random, (float)0.015625f);
        center = center.add(offset);
        Vec3 target = VecHelper.rotate((Vec3)new Vec3(0.0, -0.5, (double)0.2f), (double)yRot, (Direction.Axis)Direction.Axis.Y);
        this.level.addParticle((ParticleOptions)data, center.x, center.y, center.z, target.x, target.y, target.z);
    }

    public boolean canProcess(ItemStack stack) {
        if (this.level == null) {
            return false;
        }
        Optional<RecipeHolder<CrushingRecipe>> recipe = this.findCurrentRecipe(stack);
        if (recipe.isEmpty()) {
            return false;
        }
        boolean emptySlot = this.outputInv.getStackInSlot(0).isEmpty();
        if (emptySlot) {
            return true;
        }
        TieredSingleRecipeInput input = new TieredSingleRecipeInput(stack, this.tier.get().intValue());
        boolean matchingItem = this.outputInv.getStackInSlot(0).is(((CrushingRecipe)recipe.get().value()).assemble((RecipeInput)input, (HolderLookup.Provider)this.level.registryAccess()).getItem());
        if (!matchingItem) {
            return false;
        }
        ItemStack output = ((CrushingRecipe)recipe.get().value()).assemble((RecipeInput)input, (HolderLookup.Provider)this.level.registryAccess());
        ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)this.outputInv, (ItemStack)output, (boolean)true);
        return remainder.isEmpty();
    }

    private Optional<RecipeHolder<CrushingRecipe>> findCurrentRecipe(ItemStack stack) {
        if (this.level == null) {
            return Optional.empty();
        }
        TieredSingleRecipeInput input = new TieredSingleRecipeInput(stack, this.tier.get().intValue());
        if (this.lastRecipe != null && ((CrushingRecipe)this.lastRecipe.value()).matches(input, this.level)) {
            return Optional.ofNullable(this.lastRecipe);
        }
        Optional recipe = this.level.getRecipeManager().getRecipeFor((RecipeType)OccultismRecipes.CRUSHING_TYPE.get(), (RecipeInput)input, this.level);
        recipe.ifPresent(r -> {
            this.lastRecipe = r;
        });
        return recipe;
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        compound.putInt("timer", this.timer);
        compound.put("input_inventory", (Tag)this.inputInv.serializeNBT(registries));
        compound.put("output_inventory", (Tag)this.outputInv.serializeNBT(registries));
        super.write(compound, registries, clientPacket);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        this.timer = compound.getInt("timer");
        this.inputInv.deserializeNBT(registries, compound.getCompound("input_inventory"));
        this.outputInv.deserializeNBT(registries, compound.getCompound("output_inventory"));
        super.read(compound, registries, clientPacket);
    }

    private class PulverizerInventoryHandler
    extends CombinedInvWrapper {
        public PulverizerInventoryHandler() {
            super(new IItemHandlerModifiable[]{PulverizerBlockEntity.this.inputInv, PulverizerBlockEntity.this.outputInv});
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (PulverizerBlockEntity.this.outputInv == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return false;
            }
            return PulverizerBlockEntity.this.canProcess(stack) && super.isItemValid(slot, stack);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (PulverizerBlockEntity.this.outputInv == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return stack;
            }
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (PulverizerBlockEntity.this.inputInv == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return ItemStack.EMPTY;
            }
            return super.extractItem(slot, amount, simulate);
        }
    }
}

