/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.levelio.data;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.creeperhost.levelio.LevelIO;
import net.creeperhost.levelio.data.Chunk;
import net.creeperhost.levelio.lib.ChunkPos;
import net.creeperhost.levelio.lib.MCAFile;
import net.creeperhost.levelio.loader.LevelInfo;
import org.jetbrains.annotations.Nullable;

public class Region {
    public final ChunkPos pos;
    public final LevelIO levelIO;
    public final LevelInfo levelInfo;
    private Map<ChunkPos, Path> mccPaths = new HashMap<ChunkPos, Path>();
    private Map<ChunkPos, Chunk> loadedChunks = new HashMap<ChunkPos, Chunk>();
    private MCAFile regionFile;
    private final boolean readOnly;
    private MCAFile entityFile;
    private long lastModified;
    private long fileSize;

    public Region(LevelIO levelIO, LevelInfo levelInfo, Path file, boolean readOnly) throws IOException {
        this.levelIO = levelIO;
        this.levelInfo = levelInfo;
        this.readOnly = readOnly;
        this.pos = ChunkPos.fromMCAorMCC(file.getFileName().toString());
        this.regionFile = new MCAFile(file, readOnly);
        this.lastModified = Files.getLastModifiedTime(file, new LinkOption[0]).toMillis();
        this.fileSize = Files.size(file);
    }

    public void addMCC(ChunkPos pos, Path mccPath) {
        this.mccPaths.put(pos, mccPath);
    }

    public void addEntityMCA(Path file) throws IOException {
        this.entityFile = new MCAFile(file, this.readOnly);
    }

    public MCAFile getRegionMCA() {
        return this.regionFile;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    @Nullable
    public Chunk loadChunk(int chunkX, int chunkZ) throws IOException {
        return this.loadChunk(new ChunkPos(chunkX, chunkZ));
    }

    @Nullable
    public Chunk loadChunk(ChunkPos pos) throws IOException {
        if (!this.loadedChunks.containsKey(pos)) {
            Chunk chunk = null;
            if (this.regionFile.hasChunk(pos)) {
                chunk = new Chunk(this, pos, this.regionFile, this.entityFile);
                if (this.mccPaths.containsKey(pos)) {
                    chunk.setMccFile(this.mccPaths.get(pos));
                }
            }
            this.loadedChunks.put(pos, chunk);
        }
        return this.loadedChunks.get(pos);
    }

    public void unloadChunk(ChunkPos pos) {
        this.loadedChunks.remove(pos);
    }

    public void close() {
        this.regionFile.close();
        if (this.entityFile != null) {
            this.entityFile.close();
        }
    }
}

