/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.mcf;

import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.Network;
import org.zeith.hammerlib.net.packets.PacketAdvancementToast;

public class AdvancementUtils {
    public static boolean isAdvancementCompleted(ResourceLocation advancement, Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer mp = (ServerPlayer)player;
            AdvancementHolder adv = mp.server.getAdvancements().get(advancement);
            if (adv == null) {
                return false;
            }
            return mp.getAdvancements().getOrStartProgress(adv).isDone();
        }
        return false;
    }

    public static void completeAdvancement(ResourceLocation advancement, Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer mp = (ServerPlayer)player;
            AdvancementHolder adv = mp.server.getAdvancements().get(advancement);
            if (adv == null) {
                return;
            }
            AdvancementProgress prog = mp.getAdvancements().getOrStartProgress(adv);
            boolean done = prog.isDone();
            if (!done) {
                for (String criteria : prog.getRemainingCriteria()) {
                    prog.grantProgress(criteria);
                }
            }
            if (!done && prog.isDone()) {
                Network.sendTo((IPacket)new PacketAdvancementToast(advancement), mp);
            }
        }
    }
}

