/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.java.reflection;

import com.google.common.base.Suppliers;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.zeith.hammerlib.util.java.Cast;

public class Accessor {
    private static final Set<String> MISSING_CLASSES = Collections.synchronizedSet(new HashSet());
    private static final Set<String> MISSING_CLASS_MEMBERS = Collections.synchronizedSet(new HashSet());
    public final String theClass;
    public final String member;
    protected final Supplier<Class<?>> lazyClass;

    public Accessor(String theClass, String member) {
        this.theClass = theClass;
        this.member = member;
        this.lazyClass = Suppliers.memoize(() -> {
            try {
                return Class.forName(theClass);
            }
            catch (Throwable e) {
                if (MISSING_CLASSES.add(theClass)) {
                    e.printStackTrace();
                }
                return null;
            }
        });
    }

    @Nullable
    public <T> T staticGet() {
        return this.get(null);
    }

    @Nullable
    public <T> T get(Object instance) {
        try {
            Field f = this.lazyClass.get().getDeclaredField(this.member);
            f.setAccessible(true);
            return Cast.cast(f.get(instance));
        }
        catch (ReflectiveOperationException e) {
            if (MISSING_CLASS_MEMBERS.add(this.theClass + "/get/" + this.member)) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public <T> Optional<T> opt(Object instance, Class<T> desiredType) {
        try {
            Field f = this.lazyClass.get().getDeclaredField(this.member);
            f.setAccessible(true);
            return Cast.optionally(f.get(instance), desiredType);
        }
        catch (ReflectiveOperationException e) {
            if (MISSING_CLASS_MEMBERS.add(this.theClass + "/get/" + this.member)) {
                e.printStackTrace();
            }
            return Optional.empty();
        }
    }

    public <T> void set(Object instance, T value) {
        block2: {
            try {
                Field f = this.lazyClass.get().getDeclaredField(this.member);
                f.setAccessible(true);
                f.set(instance, value);
            }
            catch (ReflectiveOperationException e) {
                if (!MISSING_CLASS_MEMBERS.add(this.theClass + "/set/" + this.member)) break block2;
                e.printStackTrace();
            }
        }
    }

    public Object invoke(Object instance, Class<?>[] paramTypes, Object ... paramValues) {
        try {
            Method f = this.lazyClass.get().getDeclaredMethod(this.member, paramTypes);
            f.setAccessible(true);
            return f.invoke(instance, paramValues);
        }
        catch (ReflectiveOperationException e) {
            if (MISSING_CLASS_MEMBERS.add(this.theClass + "/invoke/" + this.member)) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public String toString() {
        return "Accessor{class='" + this.theClass + "', member='" + this.member + "'}";
    }
}

