/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.colors;

import com.mojang.blaze3d.systems.RenderSystem;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.zeith.hammerlib.util.colors.ColorNamePicker;
import org.zeith.hammerlib.util.java.NumberUtils;

public class ColorHelper {
    public static String getColorName(int rgb) {
        return ColorNamePicker.getColorNameFromHex(rgb);
    }

    public static int getColorByName(String name) {
        Integer i = ColorNamePicker.trySearchColorFor(name);
        return i != null ? i : 0xFFFFFF;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void glColor1ia(int argb) {
        RenderSystem.setShaderColor((float)ColorHelper.getRed(argb), (float)ColorHelper.getGreen(argb), (float)ColorHelper.getBlue(argb), (float)ColorHelper.getAlpha(argb));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void glColor1i(int argb) {
        RenderSystem.setShaderColor((float)ColorHelper.getRed(argb), (float)ColorHelper.getGreen(argb), (float)ColorHelper.getBlue(argb), (float)1.0f);
    }

    public static int multiply(int argb, float multi) {
        return ColorHelper.packARGB(ColorHelper.getAlpha(argb) * multi, ColorHelper.getRed(argb) * multi, ColorHelper.getGreen(argb) * multi, ColorHelper.getBlue(argb) * multi);
    }

    public static int packARGB(float a, float r, float g, float b) {
        return (int)(a * 255.0f) << 24 | (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f);
    }

    public static int packRGB(float r, float g, float b) {
        return (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f);
    }

    public static int packARGBi(int a, int r, int g, int b) {
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int packRGBi(int r, int g, int b) {
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public static float getAlpha(int rgb) {
        return (float)(rgb >> 24 & 0xFF) / 255.0f;
    }

    public static float getRed(int rgb) {
        return (float)(rgb >> 16 & 0xFF) / 255.0f;
    }

    public static float getGreen(int rgb) {
        return (float)(rgb >> 8 & 0xFF) / 255.0f;
    }

    public static float getBlue(int rgb) {
        return (float)(rgb >> 0 & 0xFF) / 255.0f;
    }

    public static int getAlphai(int rgb) {
        return rgb >> 24 & 0xFF;
    }

    public static int getRedi(int rgb) {
        return rgb >> 16 & 0xFF;
    }

    public static int getGreeni(int rgb) {
        return rgb >> 8 & 0xFF;
    }

    public static int getBluei(int rgb) {
        return rgb >> 0 & 0xFF;
    }

    public static float getBrightnessF(int rgb) {
        return ColorHelper.getRed(rgb) * ColorHelper.getGreen(rgb) * ColorHelper.getBlue(rgb);
    }

    public static int getBrightnessRGB(int rgb) {
        int bri = (int)(ColorHelper.getBrightnessF(rgb) * 255.0f);
        return bri << 16 | bri << 8 | bri;
    }

    public static float luma(float red, float green, float blue) {
        return red * 0.299f + green * 0.587f + blue * 0.114f;
    }

    public static float lumai(int red, int green, int blue) {
        return (float)red / 255.0f * 0.299f + (float)green / 255.0f * 0.587f + (float)blue / 255.0f * 0.114f;
    }

    public static double luma(int rgb) {
        return ColorHelper.luma(ColorHelper.getRed(rgb), ColorHelper.getGreen(rgb), ColorHelper.getBlue(rgb));
    }

    public static int interpolateSine(int a, int b, float progress) {
        return ColorHelper.interpolate(a, b, progress <= 0.0f ? 0.0f : (progress >= 1.0f ? 1.0f : NumberUtils.progressToSinef(progress)));
    }

    public static int interpolate(int a, int b, float progress) {
        float rs = ColorHelper.getRed(a) * (1.0f - progress) + ColorHelper.getRed(b) * progress;
        float gs = ColorHelper.getGreen(a) * (1.0f - progress) + ColorHelper.getGreen(b) * progress;
        float bs = ColorHelper.getBlue(a) * (1.0f - progress) + ColorHelper.getBlue(b) * progress;
        float as = ColorHelper.getAlpha(a) * (1.0f - progress) + ColorHelper.getAlpha(b) * progress;
        return ColorHelper.packARGB(as, rs, gs, bs);
    }
}

