/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.tiles;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.zeith.hammerlib.abstractions.sources.IObjectSource;
import org.zeith.hammerlib.api.io.NBTSerializationHelper;
import org.zeith.hammerlib.api.tiles.ISyncableTile;
import org.zeith.hammerlib.net.properties.IPropertyTile;
import org.zeith.hammerlib.net.properties.PropertyDispatcher;

public class TileSyncable
extends BlockEntity
implements ISyncableTile,
IPropertyTile {
    protected final PropertyDispatcher dispatcher = new PropertyDispatcher(IObjectSource.ofTile(this), this::syncProperties);
    protected Random rand = new Random();

    public TileSyncable(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public PropertyDispatcher getProperties() {
        return this.dispatcher;
    }

    public RegistryAccess registryAccess() {
        return this.level.registryAccess();
    }

    public Random getRNG() {
        if (this.rand == null) {
            this.rand = new Random();
        }
        return this.rand;
    }

    public boolean isOnServer() {
        return this.level != null && !this.level.isClientSide;
    }

    public boolean isOnClient() {
        return this.level != null && this.level.isClientSide;
    }

    public CompoundTag writeNBT(CompoundTag nbt, HolderLookup.Provider provider) {
        return NBTSerializationHelper.serialize(provider, this);
    }

    public void readNBT(CompoundTag nbt, HolderLookup.Provider provider) {
        NBTSerializationHelper.deserialize(provider, this, nbt);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.readNBT(nbt.getCompound("HL"), provider);
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.saveAdditional(nbt, provider);
        nbt.put("HL", (Tag)this.writeNBT(new CompoundTag(), provider));
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        CompoundTag tag = pkt.getTag();
        if (tag != null) {
            this.handleUpdateTag(tag, lookupProvider);
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.writeNBT(new CompoundTag(), provider);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        this.readNBT(tag, provider);
    }
}

