/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.net.properties;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import org.zeith.hammerlib.api.io.serializers.codec.ICodecSerializer;
import org.zeith.hammerlib.net.properties.PropertyBase;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.java.DirectStorage;

public class PropertyBaseCodec<T>
extends PropertyBase<T> {
    protected final Codec<T> codec;
    protected final Supplier<T> defaultValue;

    public PropertyBaseCodec(ICodecSerializer<T> serializer, DirectStorage<T> value) {
        this(serializer.codec(), serializer::defaultValue, serializer.type(), value);
    }

    public PropertyBaseCodec(ICodecSerializer<T> serializer) {
        this(serializer.codec(), serializer::defaultValue, serializer.type());
    }

    public PropertyBaseCodec(Codec<T> codec, Supplier<T> defaultValue, Class<T> type, DirectStorage<T> value) {
        super(type, value);
        this.codec = codec;
        this.defaultValue = defaultValue;
    }

    public PropertyBaseCodec(Codec<T> codec, Supplier<T> defaultValue, Class<T> type) {
        super(type);
        this.codec = codec;
        this.defaultValue = defaultValue;
    }

    @Override
    public void write(RegistryFriendlyByteBuf buf) {
        Object value = this.value.get();
        Optional res = value == null ? Optional.empty() : this.codec.encodeStart((DynamicOps)NbtOps.INSTANCE, value).result().flatMap(tag -> Cast.optionally(tag, CompoundTag.class));
        buf.writeBoolean(res.isPresent());
        if (res.isPresent()) {
            buf.writeNbt((Tag)res.orElseThrow());
        }
    }

    @Override
    public void read(RegistryFriendlyByteBuf buf) {
        if (buf.readBoolean()) {
            this.value.set(this.codec.decode((DynamicOps)NbtOps.INSTANCE, (Object)buf.readNbt()).result().map(Pair::getFirst).orElseGet(this.defaultValue));
        } else {
            this.value.set(this.defaultValue.get());
        }
    }
}

