/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.net.packets;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.MainThreaded;
import org.zeith.hammerlib.net.PacketContext;

@MainThreaded
public class PacketRequestTileSync
implements IPacket {
    BlockPos pos;

    public PacketRequestTileSync() {
    }

    public PacketRequestTileSync(BlockPos pos) {
        this.pos = pos;
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
    }

    @Override
    public void serverExecute(PacketContext ctx) {
        ServerPlayer s = ctx.getSender();
        if (s == null) {
            return;
        }
        BlockEntity be = s.level().getBlockEntity(this.pos);
        if (be == null) {
            return;
        }
        Packet pkt = be.getUpdatePacket();
        if (pkt == null) {
            return;
        }
        s.connection.send(pkt);
    }
}

