/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.mixins;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagLoader;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.event.recipe.BuildTagsEvent;

@Mixin(value={TagLoader.class})
public class TagLoaderMixin {
    @Shadow
    @Final
    private String directory;

    @Inject(method={"build(Ljava/util/Map;)Ljava/util/Map;"}, at={@At(value="HEAD")})
    private void load_HammerLib(Map<ResourceLocation, List<TagLoader.EntryWithSource>> value, CallbackInfoReturnable<Map<ResourceLocation, Collection>> cir) {
        Registry reg = BuiltInRegistries.REGISTRY.stream().filter(t -> Registries.tagsDirPath((ResourceKey)t.key()).equals(this.directory)).findFirst().orElse(null);
        if (reg != null) {
            HammerLib.postEvent(new BuildTagsEvent(reg, this.directory, value));
            HammerLib.LOG.info("Built tags for registry {}", (Object)reg.key().location());
        } else {
            HammerLib.LOG.debug("Unable to find registry for tag directory {}.", (Object)this.directory);
        }
    }
}

