/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.test.machine;

import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.zeith.hammerlib.api.forge.ContainerAPI;
import org.zeith.hammerlib.api.inv.ComplexProgressHandler;
import org.zeith.hammerlib.api.inv.IScreenContainer;
import org.zeith.hammerlib.client.screen.MenuWithProgressBars;
import org.zeith.hammerlib.core.test.machine.ScreenTestMachine;
import org.zeith.hammerlib.core.test.machine.TileTestMachine;

public class ContainerTestMachine
extends MenuWithProgressBars
implements IScreenContainer {
    public TileTestMachine tile;

    public ContainerTestMachine(Player player, int windowId, TileTestMachine tile) {
        super(ContainerAPI.TILE_CONTAINER, windowId, ComplexProgressHandler.withProperties(List.of(tile.progress, tile.maxProgress), player.registryAccess()));
        int x;
        this.tile = tile;
        for (x = 0; x < 3; ++x) {
            for (int y = 0; y < 9; ++y) {
                this.addSlot(new Slot((Container)player.getInventory(), y + x * 9 + 9, 8 + y * 18, 84 + x * 18));
            }
        }
        for (x = 0; x < 9; ++x) {
            this.addSlot(new Slot((Container)player.getInventory(), x, 8 + x * 18, 142));
        }
        this.addSlot(new Slot((Container)tile.inventory, 0, 56, 17));
        this.addSlot(new Slot((Container)tile.inventory, 1, 56, 53));
        this.addSlot(new Slot((Container)tile.inventory, 2, 116, 35));
    }

    public boolean stillValid(Player playerIn) {
        return this.tile.getBlockPos().closerToCenterThan((Position)playerIn.position(), 64.0) && !this.tile.isRemoved();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Screen openScreen(Inventory inv, Component label) {
        return new ScreenTestMachine(this, inv, label);
    }

    public ItemStack quickMoveStack(Player player, int slot) {
        return ItemStack.EMPTY;
    }
}

