/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import org.zeith.hammerlib.core.RegistriesHL;
import org.zeith.hammerlib.core.init.RecipesHL;
import org.zeith.hammerlib.core.recipes.replacers.IRemainingItemReplacer;

public class HLShapedRecipe
extends ShapedRecipe {
    protected final List<IRemainingItemReplacer> inputModifier = new ArrayList<IRemainingItemReplacer>();

    public HLShapedRecipe(String group, CraftingBookCategory category, ShapedRecipePattern pattern, ItemStack result, boolean showNotification) {
        super(group, category, pattern, result, showNotification);
    }

    public HLShapedRecipe(String group, CraftingBookCategory category, ShapedRecipePattern pattern, ItemStack result) {
        super(group, category, pattern, result);
    }

    public HLShapedRecipe addReplacer(ResourceLocation id) {
        IRemainingItemReplacer m = (IRemainingItemReplacer)RegistriesHL.REMAINING_REPLACER.get(id);
        if (m != null) {
            this.inputModifier.add(m);
        }
        return this;
    }

    public HLShapedRecipe addReplacers(ResourceLocation ... id) {
        for (ResourceLocation i : id) {
            this.inputModifier.add((IRemainingItemReplacer)RegistriesHL.REMAINING_REPLACER.get(i));
        }
        this.inputModifier.removeIf(Objects::isNull);
        return this;
    }

    public HLShapedRecipe addReplacers(Iterable<ResourceLocation> id) {
        for (ResourceLocation i : id) {
            this.inputModifier.add((IRemainingItemReplacer)RegistriesHL.REMAINING_REPLACER.get(i));
        }
        this.inputModifier.removeIf(Objects::isNull);
        return this;
    }

    public RecipeSerializer<?> getSerializer() {
        return RecipesHL.SHAPED_HL_SERIALIZER;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput ctr) {
        NonNullList remaining = super.getRemainingItems((RecipeInput)ctr);
        for (IRemainingItemReplacer replacer : this.inputModifier) {
            for (int i = 0; i < remaining.size(); ++i) {
                remaining.set(i, (Object)replacer.replace(ctr, i, (ItemStack)remaining.get(i)));
            }
        }
        return remaining;
    }

    static String[] shrink(List<String> lst) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int i1 = 0; i1 < lst.size(); ++i1) {
            String s = lst.get(i1);
            i = Math.min(i, HLShapedRecipe.firstNonSpace(s));
            int j1 = HLShapedRecipe.lastNonSpace(s);
            j = Math.max(j, j1);
            if (j1 < 0) {
                if (k == i1) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (lst.size() == l) {
            return new String[0];
        }
        String[] v = new String[lst.size() - l - k];
        for (int k1 = 0; k1 < v.length; ++k1) {
            v[k1] = lst.get(k1 + k).substring(i, j + 1);
        }
        return v;
    }

    private static int firstNonSpace(String str) {
        int i;
        for (i = 0; i < str.length() && str.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int lastNonSpace(String str) {
        int i;
        for (i = str.length() - 1; i >= 0 && str.charAt(i) == ' '; --i) {
        }
        return i;
    }

    @Generated
    public List<IRemainingItemReplacer> getInputModifier() {
        return this.inputModifier;
    }

    public static class HLSerializer
    implements RecipeSerializer<HLShapedRecipe> {
        public static final MapCodec<HLShapedRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(ShapedRecipe::getGroup), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(i -> i.category), (App)ShapedRecipePattern.MAP_CODEC.forGetter(i -> i.pattern), (App)ItemStack.CODEC.fieldOf("result").forGetter(i -> i.result), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)true).forGetter(ShapedRecipe::showNotification)).apply((Applicative)inst, HLShapedRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, HLShapedRecipe> STREAM_CODEC = StreamCodec.of(HLSerializer::toNetwork, HLSerializer::fromNetwork);

        public MapCodec<HLShapedRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, HLShapedRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static HLShapedRecipe fromNetwork(RegistryFriendlyByteBuf buf) {
            ShapedRecipe base = (ShapedRecipe)RecipeSerializer.SHAPED_RECIPE.streamCodec().decode((Object)buf);
            HLShapedRecipe mod = new HLShapedRecipe(base.group, base.category, base.pattern, base.result, base.showNotification);
            mod.inputModifier.addAll(IRemainingItemReplacer.fromNetwork((FriendlyByteBuf)buf));
            return mod;
        }

        public static void toNetwork(RegistryFriendlyByteBuf buf, HLShapedRecipe r) {
            RecipeSerializer.SHAPED_RECIPE.streamCodec().encode((Object)buf, (Object)r);
            IRemainingItemReplacer.toNetwork(r.inputModifier, (FriendlyByteBuf)buf);
        }
    }
}

