/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.items.tooltip;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import org.zeith.hammerlib.api.items.tooltip.TooltipColoredLine;
import org.zeith.hammerlib.client.utils.RenderUtils;

public class ClientTooltipColoredLine
implements ClientTooltipComponent {
    private final TooltipColoredLine colors;

    public ClientTooltipColoredLine(TooltipColoredLine colors) {
        this.colors = colors;
    }

    public int getHeight() {
        return 1;
    }

    public int getWidth(Font font) {
        return this.colors.getColors().size() / 2;
    }

    public void renderImage(Font font, int x, int y, GuiGraphics gfx) {
        PoseStack pose = gfx.pose();
        pose.pushPose();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        IntListIterator intListIterator = this.colors.getColors().iterator();
        while (intListIterator.hasNext()) {
            int color = (Integer)intListIterator.next();
            RenderUtils.drawColoredModalRect(gfx, x, y, 0.5f, 1.0f, color);
            pose.translate(0.5f, 0.0f, 0.0f);
        }
        pose.popPose();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
    }
}

