/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.adapter.recipe;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipePattern;

public class RecipeShape {
    public final int width;
    public final int height;
    public final List<String> shape;

    public RecipeShape(int width, int height, String ... shape) {
        if (height != shape.length) {
            throw new IllegalArgumentException("Invalid height passed for shapeKeys; Expected " + height + ", got " + shape.length);
        }
        for (int i = 0; i < shape.length; ++i) {
            String key = shape[i];
            if (key.length() == width) continue;
            throw new IllegalArgumentException("Invalid width passed at shapeKeys[" + i + "]=\"" + key + "\"; Expected " + width + ", got " + key.length());
        }
        this.width = width;
        this.height = height;
        this.shape = Arrays.asList(shape);
    }

    public RecipeShape(String ... shape) {
        this.width = shape[0].length();
        this.height = shape.length;
        this.shape = Arrays.asList(shape);
        for (int i = 0; i < shape.length; ++i) {
            String key = shape[i];
            if (key.length() == this.width) continue;
            throw new IllegalArgumentException("Invalid width passed at shape[" + i + "]=\"" + key + "\"; Expected " + this.width + ", got " + key.length());
        }
    }

    public NonNullList<Ingredient> createIngredientMap(Map<Character, Ingredient> dictionary) {
        StringBuilder s = new StringBuilder();
        for (String s2 : this.shape) {
            s.append(s2);
        }
        NonNullList grid = NonNullList.withSize((int)(this.width * this.height), (Object)Ingredient.EMPTY);
        for (int l = 0; l < this.width * this.height; ++l) {
            char c0 = s.charAt(l);
            if (!dictionary.containsKey(Character.valueOf(c0))) continue;
            grid.set(l, (Object)dictionary.get(Character.valueOf(c0)));
        }
        return grid;
    }

    public ShapedRecipePattern build(Map<Character, Ingredient> dictionary) {
        return new ShapedRecipePattern(this.width, this.height, this.createIngredientMap(dictionary), Optional.empty());
    }
}

