/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.adapter;

import com.google.common.collect.Sets;
import java.io.FileNotFoundException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.event.LanguageReloadEvent;
import org.zeith.hammerlib.util.mcf.Resources;

public class LanguageAdapter {
    private static final Set<String> modids = Sets.newConcurrentHashSet();

    public static void registerMod(String modid) {
        modids.add(modid);
    }

    public static void reloadLangs(LanguageReloadEvent e) {
        ResourceManager mgr = e.getResources();
        HammerLib.LOG.debug("Reloading HammerLib-enabled language namespaces: " + String.valueOf(mgr.getNamespaces()));
        for (String modId : modids) {
            LanguageAdapter.findFirstExisting(mgr, Resources.location(modId, "langs/" + e.getLang().toLowerCase() + "._hl"), Resources.location(modId, "lang/" + e.getLang().toLowerCase() + "._hl"), Resources.location(modId, "langs/" + e.getLang().toLowerCase() + ".lang"), Resources.location(modId, "lang/" + e.getLang().toLowerCase() + ".lang")).forEach(langFile -> {
                List resources = mgr.getResourceStack(langFile);
                try {
                    boolean logged = false;
                    for (Resource res : resources) {
                        try (Scanner in = new Scanner(res.open(), StandardCharsets.UTF_8);){
                            if (!logged) {
                                HammerLib.LOG.debug("Hooking HammerLib language adapter for namespace " + modId + ": " + String.valueOf(langFile));
                                logged = true;
                            }
                            while (in.hasNextLine()) {
                                String[] kv;
                                String line = in.nextLine();
                                if (line.startsWith("#") || (kv = line.split("=", 2)).length != 2) continue;
                                e.translate(kv[0], kv[1]);
                            }
                        }
                    }
                }
                catch (FileNotFoundException logged) {
                }
                catch (Throwable ex) {
                    HammerLib.LOG.error("Failed to load language file located at " + String.valueOf(langFile), ex);
                }
            });
        }
    }

    private static Stream<ResourceLocation> findFirstExisting(ResourceManager mgr, ResourceLocation ... paths) {
        return Stream.of(paths);
    }

    static {
        HammerLib.EVENT_BUS.addListener(LanguageAdapter::reloadLangs);
    }
}

