/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.adapter;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.block.Block;
import org.zeith.hammerlib.core.adapter.TagAdapter;

public class BlockHarvestAdapter {
    public static void bindToolType(MineableType tool, Block ... blocks) {
        TagAdapter.bind(tool.blockTag(), blocks);
    }

    public static void bindToolTier(Tiers tier, Block ... blocks) {
        TagAdapter.bind(Objects.requireNonNull(tier.getTag()), blocks);
    }

    public static void bindTool(MineableType tool, Tiers tier, Block ... blocks) {
        BlockHarvestAdapter.bindToolType(tool, blocks);
        BlockHarvestAdapter.bindToolTier(tier, blocks);
    }

    public record MineableType(@Nonnull TagKey<Block> blockTag) {
        public static final MineableType AXE = new MineableType((TagKey<Block>)BlockTags.MINEABLE_WITH_AXE);
        public static final MineableType HOE = new MineableType((TagKey<Block>)BlockTags.MINEABLE_WITH_HOE);
        public static final MineableType PICKAXE = new MineableType((TagKey<Block>)BlockTags.MINEABLE_WITH_PICKAXE);
        public static final MineableType SHOVEL = new MineableType((TagKey<Block>)BlockTags.MINEABLE_WITH_SHOVEL);

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MineableType that = (MineableType)o;
            return this.blockTag.equals(that.blockTag);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.blockTag);
        }
    }
}

