/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.compat.cc;

import dan200.computercraft.shared.common.IBundledRedstoneBlock;
import dan200.computercraft.shared.computer.blocks.AbstractComputerBlockEntity;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Range;
import org.zeith.api.blocks.redstone.IRedstoneBundle;
import org.zeith.api.blocks.redstone.IRedstoneBundleAccessor;
import org.zeith.api.blocks.redstone.MCColor;

public class ComputerBundleProvider
implements IRedstoneBundle {
    public final AbstractComputerBlockEntity computer;
    public final Direction side;

    public ComputerBundleProvider(AbstractComputerBlockEntity computer, Direction side) {
        this.computer = computer;
        this.side = side;
    }

    @Override
    public boolean isConnected() {
        boolean bl;
        Block block = this.computer.getBlockState().getBlock();
        if (block instanceof IBundledRedstoneBlock) {
            IBundledRedstoneBlock blk = (IBundledRedstoneBlock)block;
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public @Range(from=0L, to=65535L) int getSerializedBundleSignal() {
        Block block = this.computer.getBlockState().getBlock();
        if (block instanceof IBundledRedstoneBlock) {
            IBundledRedstoneBlock blk = (IBundledRedstoneBlock)block;
            return blk.getBundledRedstoneOutput(this.computer.getLevel(), this.computer.getBlockPos(), this.side);
        }
        return 0;
    }

    @Override
    public boolean hasSignal(MCColor color) {
        Block block = this.computer.getBlockState().getBlock();
        if (block instanceof IBundledRedstoneBlock) {
            IBundledRedstoneBlock blk = (IBundledRedstoneBlock)block;
            int redstone = blk.getBundledRedstoneOutput(this.computer.getLevel(), this.computer.getBlockPos(), this.side);
            return IRedstoneBundleAccessor.hasSerialized(redstone, color);
        }
        return false;
    }

    @Override
    public boolean setSignal(MCColor color, boolean signal) {
        return false;
    }

    @Override
    public boolean setSerializedBundleSignal(@Range(from=0L, to=65535L) int serialized) {
        return false;
    }
}

