/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.compat.base;

import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.neoforged.fml.ModList;
import org.objectweb.asm.Type;
import org.zeith.hammerlib.compat.base.Ability;
import org.zeith.hammerlib.compat.base.BaseCompat;
import org.zeith.hammerlib.compat.base.CompatContext;
import org.zeith.hammerlib.core.adapter.OnlyIfAdapter;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.java.ReflectionUtil;
import org.zeith.hammerlib.util.mcf.Resources;
import org.zeith.hammerlib.util.mcf.ScanDataHelper;

public class CompatList<T extends BaseCompat<T>> {
    private final List<? extends T> lst;
    private final Map<Ability<?>, List<?>> cachedAbilities = new ConcurrentHashMap();

    protected CompatList(List<? extends T> lst) {
        this.lst = lst;
    }

    public static <T extends BaseCompat<T>> CompatList<T> gather(Class<T> base, CompatContext context) {
        return CompatList.gather(base, context, CompatList::new);
    }

    public static <T extends BaseCompat<T>, R extends CompatList<T>> R gather(Class<T> base, CompatContext context, Function<List<T>, R> listFun) {
        return (R)((CompatList)listFun.apply(ScanDataHelper.lookupAnnotatedObjects(BaseCompat.LoadCompat.class).stream().filter(data -> ModList.get().isLoaded(Objects.toString(data.getProperty("modid").orElse("")))).filter(data -> base.isAssignableFrom(ReflectionUtil.fetchClass((Type)data.getProperty("compatType").orElseThrow()))).filter(data -> data.getProperty("shouldLoad").map(onlyIf -> OnlyIfAdapter.checkCondition(OnlyIfAdapter.decode((Map)Cast.cast(onlyIf)), "CompatList.gather", base.getSimpleName(), data, Resources.location(Objects.toString(data.getProperty("modid").orElse("")), "root"))).orElse(true)).map(data -> {
            Class<?> cls = data.getOwnerClass();
            for (Constructor<?> ct : cls.getDeclaredConstructors()) {
                Class<?> t0;
                if (ct.getParameterCount() != 1 || !(t0 = ct.getParameterTypes()[0]).isInstance(context)) continue;
                ct.setAccessible(true);
                try {
                    return (BaseCompat)ct.newInstance(context);
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException(e);
                }
            }
            throw new RuntimeException("Unable to find suitable contructor for " + String.valueOf(data.clazz()));
        }).toList()));
    }

    public String toString() {
        return "CompatList{lst=" + String.valueOf(this.lst) + ", cachedAbilities=" + String.valueOf(this.cachedAbilities) + "}";
    }

    public List<? extends T> getActive() {
        return this.lst;
    }

    public <R> List<R> getAbilities(Ability<R> ability) {
        return (List)Cast.cast(this.cachedAbilities.computeIfAbsent(ability, a -> this.lst.stream().flatMap(c -> c.getAbility(a).stream()).toList()));
    }

    public <R> Optional<R> firstAbility(Ability<R> ability) {
        return this.getAbilities(ability).stream().findFirst();
    }
}

