/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.compat.base;

import java.util.Optional;
import java.util.function.Supplier;
import lombok.Generated;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.loading.FMLEnvironment;
import org.zeith.hammerlib.util.java.Cast;

public class CompatContext {
    protected final IEventBus modBus;
    protected final Object data;

    public void runWhenOn(Dist dist, Supplier<Runnable> toRun) {
        if (dist == FMLEnvironment.dist) {
            toRun.get().run();
        }
    }

    public <T> Optional<T> data(Class<T> type) {
        return Cast.optionally(this.data, type);
    }

    public static Builder builder(IEventBus bus) {
        return new Builder().modBus(bus);
    }

    @Generated
    CompatContext(IEventBus modBus, Object data) {
        this.modBus = modBus;
        this.data = data;
    }

    @Generated
    public IEventBus getModBus() {
        return this.modBus;
    }

    @Generated
    public Object getData() {
        return this.data;
    }

    @Generated
    public static class Builder {
        @Generated
        private IEventBus modBus;
        @Generated
        private Object data;

        @Generated
        Builder() {
        }

        @Generated
        public Builder modBus(IEventBus modBus) {
            this.modBus = modBus;
            return this;
        }

        @Generated
        public Builder data(Object data) {
            this.data = data;
            return this;
        }

        @Generated
        public CompatContext build() {
            return new CompatContext(this.modBus, this.data);
        }

        @Generated
        public String toString() {
            return "CompatContext.Builder(modBus=" + String.valueOf(this.modBus) + ", data=" + String.valueOf(this.data) + ")";
        }
    }
}

