/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.client.render.TintingVertexConsumer;
import org.zeith.hammerlib.proxy.HLConstants;

public class RenderCustomGlint {
    public static final ResourceLocation ENCHANTED_GLINT_ENTITY = HLConstants.id("textures/misc/enchanted_glint_entity.png");
    public static final ResourceLocation ENCHANTED_GLINT_ITEM = HLConstants.id("textures/misc/enchanted_glint_item.png");
    protected static final RenderStateShard.ShaderStateShard RENDERTYPE_ARMOR_GLINT_SHADER = new RenderStateShard.ShaderStateShard(GlintShaders::getArmorGlintShader);
    protected static final RenderStateShard.ShaderStateShard RENDERTYPE_ARMOR_ENTITY_GLINT_SHADER = new RenderStateShard.ShaderStateShard(GlintShaders::getArmorEntityGlintShader);
    protected static final RenderStateShard.ShaderStateShard RENDERTYPE_GLINT_TRANSLUCENT_SHADER = new RenderStateShard.ShaderStateShard(GlintShaders::getGlintTranslucentShader);
    protected static final RenderStateShard.ShaderStateShard RENDERTYPE_GLINT_SHADER = new RenderStateShard.ShaderStateShard(GlintShaders::getGlintShader);
    protected static final RenderStateShard.ShaderStateShard RENDERTYPE_GLINT_DIRECT_SHADER = new RenderStateShard.ShaderStateShard(GlintShaders::getGlintDirectShader);
    protected static final RenderStateShard.ShaderStateShard RENDERTYPE_ENTITY_GLINT_SHADER = new RenderStateShard.ShaderStateShard(GlintShaders::getEntityGlintShader);
    protected static final RenderStateShard.ShaderStateShard RENDERTYPE_ENTITY_GLINT_DIRECT_SHADER = new RenderStateShard.ShaderStateShard(GlintShaders::getEntityGlintDirectShader);
    protected static final RenderStateShard.WriteMaskStateShard COLOR_WRITE = new RenderStateShard.WriteMaskStateShard(true, false);
    protected static final RenderStateShard.CullStateShard NO_CULL = new RenderStateShard.CullStateShard(false);
    protected static final RenderStateShard.DepthTestStateShard EQUAL_DEPTH_TEST = new RenderStateShard.DepthTestStateShard("==", 514);
    protected static final RenderStateShard.TransparencyStateShard GLINT_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("glint_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    protected static final RenderStateShard.LayeringStateShard VIEW_OFFSET_Z_LAYERING = new RenderStateShard.LayeringStateShard("view_offset_z_layering", () -> {
        Matrix4fStack posestack = RenderSystem.getModelViewStack();
        posestack.pushMatrix();
        posestack.scale(0.99975586f, 0.99975586f, 0.99975586f);
        RenderSystem.applyModelViewMatrix();
    }, () -> {
        Matrix4fStack posestack = RenderSystem.getModelViewStack();
        posestack.popMatrix();
        RenderSystem.applyModelViewMatrix();
    });
    protected static final RenderStateShard.TexturingStateShard GLINT_TEXTURING = new RenderStateShard.TexturingStateShard("glint_texturing", () -> RenderCustomGlint.setupGlintTexturing(8.0f), () -> RenderSystem.resetTextureMatrix());
    protected static final RenderStateShard.TexturingStateShard ENTITY_GLINT_TEXTURING = new RenderStateShard.TexturingStateShard("entity_glint_texturing", () -> RenderCustomGlint.setupGlintTexturing(0.16f), () -> RenderSystem.resetTextureMatrix());
    protected static final RenderStateShard.OutputStateShard ITEM_ENTITY_TARGET = new RenderStateShard.OutputStateShard("item_entity_target", () -> {
        if (Minecraft.useShaderTransparency()) {
            Minecraft.getInstance().levelRenderer.getItemEntityTarget().bindWrite(false);
        }
    }, () -> {
        if (Minecraft.useShaderTransparency()) {
            Minecraft.getInstance().getMainRenderTarget().bindWrite(false);
        }
    });
    private static final RenderType ARMOR_GLINT = RenderType.create((String)"hammerlib:armor_glint", (VertexFormat)DefaultVertexFormat.POSITION_TEX_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RENDERTYPE_ARMOR_GLINT_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ENCHANTED_GLINT_ENTITY, true, false)).setWriteMaskState(COLOR_WRITE).setCullState(NO_CULL).setDepthTestState(EQUAL_DEPTH_TEST).setTransparencyState(GLINT_TRANSPARENCY).setTexturingState(GLINT_TEXTURING).setLayeringState(VIEW_OFFSET_Z_LAYERING).createCompositeState(false));
    private static final RenderType ARMOR_ENTITY_GLINT = RenderType.create((String)"hammerlib:armor_entity_glint", (VertexFormat)DefaultVertexFormat.POSITION_TEX_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RENDERTYPE_ARMOR_ENTITY_GLINT_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ENCHANTED_GLINT_ENTITY, true, false)).setWriteMaskState(COLOR_WRITE).setCullState(NO_CULL).setDepthTestState(EQUAL_DEPTH_TEST).setTransparencyState(GLINT_TRANSPARENCY).setTexturingState(ENTITY_GLINT_TEXTURING).setLayeringState(VIEW_OFFSET_Z_LAYERING).createCompositeState(false));
    private static final RenderType GLINT_TRANSLUCENT = RenderType.create((String)"hammerlib:glint_translucent", (VertexFormat)DefaultVertexFormat.POSITION_TEX_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RENDERTYPE_GLINT_TRANSLUCENT_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ENCHANTED_GLINT_ITEM, true, false)).setWriteMaskState(COLOR_WRITE).setCullState(NO_CULL).setDepthTestState(EQUAL_DEPTH_TEST).setTransparencyState(GLINT_TRANSPARENCY).setTexturingState(GLINT_TEXTURING).setOutputState(ITEM_ENTITY_TARGET).createCompositeState(false));
    private static final RenderType GLINT = RenderType.create((String)"hammerlib:glint", (VertexFormat)DefaultVertexFormat.POSITION_TEX_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RENDERTYPE_GLINT_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ENCHANTED_GLINT_ITEM, true, false)).setWriteMaskState(COLOR_WRITE).setCullState(NO_CULL).setDepthTestState(EQUAL_DEPTH_TEST).setTransparencyState(GLINT_TRANSPARENCY).setTexturingState(GLINT_TEXTURING).createCompositeState(false));
    private static final RenderType GLINT_DIRECT = RenderType.create((String)"hammerlib:glint_direct", (VertexFormat)DefaultVertexFormat.POSITION_TEX_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RENDERTYPE_GLINT_DIRECT_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ENCHANTED_GLINT_ITEM, true, false)).setWriteMaskState(COLOR_WRITE).setCullState(NO_CULL).setDepthTestState(EQUAL_DEPTH_TEST).setTransparencyState(GLINT_TRANSPARENCY).setTexturingState(GLINT_TEXTURING).createCompositeState(false));
    private static final RenderType ENTITY_GLINT = RenderType.create((String)"hammerlib:entity_glint", (VertexFormat)DefaultVertexFormat.POSITION_TEX_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RENDERTYPE_ENTITY_GLINT_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ENCHANTED_GLINT_ENTITY, true, false)).setWriteMaskState(COLOR_WRITE).setCullState(NO_CULL).setDepthTestState(EQUAL_DEPTH_TEST).setTransparencyState(GLINT_TRANSPARENCY).setOutputState(ITEM_ENTITY_TARGET).setTexturingState(ENTITY_GLINT_TEXTURING).createCompositeState(false));
    private static final RenderType ENTITY_GLINT_DIRECT = RenderType.create((String)"hammerlib:entity_glint_direct", (VertexFormat)DefaultVertexFormat.POSITION_TEX_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RENDERTYPE_ENTITY_GLINT_DIRECT_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ENCHANTED_GLINT_ENTITY, true, false)).setWriteMaskState(COLOR_WRITE).setCullState(NO_CULL).setDepthTestState(EQUAL_DEPTH_TEST).setTransparencyState(GLINT_TRANSPARENCY).setTexturingState(ENTITY_GLINT_TEXTURING).createCompositeState(false));

    private static void setupGlintTexturing(float pScale) {
        long i = (long)((double)Util.getMillis() * (Double)Minecraft.getInstance().options.glintSpeed().get() * 8.0);
        float f = (float)(i % 110000L) / 110000.0f;
        float f1 = (float)(i % 30000L) / 30000.0f;
        Matrix4f matrix4f = new Matrix4f().translation(-f, f1, 0.0f);
        matrix4f.rotateZ(0.17453292f).scale(pScale);
        RenderSystem.setTextureMatrix((Matrix4f)matrix4f);
    }

    public static VertexConsumer glintBuffer(MultiBufferSource src, GlintType type, float r, float g, float b, float a) {
        return new TintingVertexConsumer(src.getBuffer(type.type), r, g, b, a);
    }

    public static VertexConsumer glintBuffer(MultiBufferSource src, GlintType type, int rgba) {
        return new TintingVertexConsumer(src.getBuffer(type.type), rgba);
    }

    public static RenderType armorGlint() {
        return ARMOR_GLINT;
    }

    public static RenderType armorEntityGlint() {
        return ARMOR_ENTITY_GLINT;
    }

    public static RenderType glintTranslucent() {
        return GLINT_TRANSLUCENT;
    }

    public static RenderType glint() {
        return GLINT;
    }

    public static RenderType glintDirect() {
        return GLINT_DIRECT;
    }

    public static RenderType entityGlint() {
        return ENTITY_GLINT;
    }

    public static RenderType entityGlintDirect() {
        return ENTITY_GLINT_DIRECT;
    }

    public static enum GlintType {
        ARMOR_GLINT(ARMOR_GLINT),
        ARMOR_ENTITY_GLINT(ARMOR_ENTITY_GLINT),
        GLINT_TRANSLUCENT(GLINT_TRANSLUCENT),
        GLINT(GLINT),
        GLINT_DIRECT(GLINT_DIRECT),
        ENTITY_GLINT(ENTITY_GLINT),
        ENTITY_GLINT_DIRECT(ENTITY_GLINT_DIRECT);

        final RenderType type;

        private GlintType(RenderType type) {
            this.type = type;
        }
    }

    @EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class GlintShaders {
        private static ShaderInstance armorGlintShader;
        private static ShaderInstance armorEntityGlintShader;
        private static ShaderInstance glintTranslucentShader;
        private static ShaderInstance glintShader;
        private static ShaderInstance glintDirectShader;
        private static ShaderInstance entityGlintShader;
        private static ShaderInstance entityGlintDirectShader;

        @SubscribeEvent
        public static void registerShaders(RegisterShadersEvent e) {
            ResourceProvider pResourceProvider = e.getResourceProvider();
            try {
                e.registerShader(new ShaderInstance(pResourceProvider, HLConstants.id("rendertype_armor_glint").toString(), DefaultVertexFormat.POSITION_TEX_COLOR), s -> {
                    armorGlintShader = s;
                });
                e.registerShader(new ShaderInstance(pResourceProvider, HLConstants.id("rendertype_armor_entity_glint").toString(), DefaultVertexFormat.POSITION_TEX_COLOR), s -> {
                    armorEntityGlintShader = s;
                });
                e.registerShader(new ShaderInstance(pResourceProvider, HLConstants.id("rendertype_glint_translucent").toString(), DefaultVertexFormat.POSITION_TEX_COLOR), s -> {
                    glintTranslucentShader = s;
                });
                e.registerShader(new ShaderInstance(pResourceProvider, HLConstants.id("rendertype_glint").toString(), DefaultVertexFormat.POSITION_TEX_COLOR), s -> {
                    glintShader = s;
                });
                e.registerShader(new ShaderInstance(pResourceProvider, HLConstants.id("rendertype_glint_direct").toString(), DefaultVertexFormat.POSITION_TEX_COLOR), s -> {
                    glintDirectShader = s;
                });
                e.registerShader(new ShaderInstance(pResourceProvider, HLConstants.id("rendertype_entity_glint").toString(), DefaultVertexFormat.POSITION_TEX_COLOR), s -> {
                    entityGlintShader = s;
                });
                e.registerShader(new ShaderInstance(pResourceProvider, HLConstants.id("rendertype_entity_glint_direct").toString(), DefaultVertexFormat.POSITION_TEX_COLOR), s -> {
                    entityGlintDirectShader = s;
                });
                HammerLib.LOG.info("Reloaded glint shaders.");
            }
            catch (IOException err) {
                HammerLib.LOG.error("Failed to reload shaders.", (Throwable)err);
            }
        }

        @Nullable
        public static ShaderInstance getArmorGlintShader() {
            return armorGlintShader;
        }

        @Nullable
        public static ShaderInstance getArmorEntityGlintShader() {
            return armorEntityGlintShader;
        }

        @Nullable
        public static ShaderInstance getGlintTranslucentShader() {
            return glintTranslucentShader;
        }

        @Nullable
        public static ShaderInstance getGlintShader() {
            return glintShader;
        }

        @Nullable
        public static ShaderInstance getGlintDirectShader() {
            return glintDirectShader;
        }

        @Nullable
        public static ShaderInstance getEntityGlintShader() {
            return entityGlintShader;
        }

        @Nullable
        public static ShaderInstance getEntityGlintDirectShader() {
            return entityGlintDirectShader;
        }
    }
}

