/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.zeith.hammerlib.client.utils.FXUtils;
import org.zeith.hammerlib.client.utils.FluidTextureType;
import org.zeith.hammerlib.util.colors.ColorHelper;

public class FluidRendererHelper {
    public static void renderFluidInGui(PoseStack pose, FluidStack fluid, FluidTextureType type, float full, float x, float y, float width, float height) {
        if (!fluid.isEmpty()) {
            TextureAtlasSprite sprite = FluidRendererHelper.getFluidTexture(fluid, type);
            int argb = FluidRendererHelper.getColorARGB(fluid);
            float a = ColorHelper.getAlpha(argb);
            float r = ColorHelper.getRed(argb);
            float g = ColorHelper.getGreen(argb);
            float b = ColorHelper.getBlue(argb);
            float heightF = height * full;
            if (heightF > 0.0f) {
                FXUtils.bindTexture(InventoryMenu.BLOCK_ATLAS);
                Tesselator tess = Tesselator.getInstance();
                BufferBuilder bb = tess.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                float[] colors = (float[])RenderSystem.getShaderColor().clone();
                RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
                Matrix4f pose4f = pose.last().pose();
                float minX = sprite.getU(0.0f);
                float maxX = sprite.getU(16.0f);
                float maxY = sprite.getV(16.0f);
                float ys = 0.0f;
                while (heightF > 0.0f) {
                    float ch = Math.min(width, heightF);
                    float yCoord = y + height - ch - ys;
                    float minY = sprite.getV(16.0f - Math.min(16.0f, heightF * 16.0f / width));
                    bb.addVertex(pose4f, x, yCoord + ch, 0.0f).setUv(minX, maxY);
                    bb.addVertex(pose4f, x + width, yCoord + ch, 0.0f).setUv(maxX, maxY);
                    bb.addVertex(pose4f, x + width, yCoord, 0.0f).setUv(maxX, minY);
                    bb.addVertex(pose4f, x, yCoord, 0.0f).setUv(minX, minY);
                    heightF -= ch;
                    ys += ch;
                }
                BufferUploader.drawWithShader((MeshData)bb.build());
                RenderSystem.setShaderColor((float)colors[0], (float)colors[1], (float)colors[2], (float)colors[3]);
            }
        }
    }

    public static TextureAtlasSprite getBaseFluidTexture(@NotNull Fluid fluid, @NotNull FluidTextureType type) {
        IClientFluidTypeExtensions properties = IClientFluidTypeExtensions.of((Fluid)fluid);
        ResourceLocation spriteLocation = type == FluidTextureType.STILL ? properties.getStillTexture() : properties.getFlowingTexture();
        return FluidRendererHelper.getSprite(spriteLocation);
    }

    public static int getColorARGB(@NotNull FluidStack fluidStack) {
        return IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid()).getTintColor(fluidStack);
    }

    public static TextureAtlasSprite getFluidTexture(@NotNull FluidStack fluidStack, @NotNull FluidTextureType type) {
        IClientFluidTypeExtensions properties = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
        return FluidRendererHelper.getSprite(type == FluidTextureType.STILL ? properties.getStillTexture(fluidStack) : properties.getFlowingTexture(fluidStack));
    }

    public static TextureAtlasSprite getSprite(ResourceLocation spriteLocation) {
        return (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(spriteLocation);
    }

    public static int calculateGlowLight(int combinedLight, @NotNull FluidStack fluid) {
        return fluid.isEmpty() ? combinedLight : FluidRendererHelper.calculateGlowLight(combinedLight, fluid.getFluid().getFluidType().getLightLevel(fluid));
    }

    public static int calculateGlowLight(int combinedLight, int glow) {
        return combinedLight & 0xFFFF0000 | Math.max(Math.min(glow, 15) << 4, combinedLight & 0xFFFF);
    }
}

