/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.flowgui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import lombok.Generated;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeith.hammerlib.client.flowgui.Graphics;
import org.zeith.hammerlib.client.flowgui.GuiObjectBuilder;
import org.zeith.hammerlib.client.flowgui.MousePos;
import org.zeith.hammerlib.client.flowgui.objects.GuiRootObject;
import org.zeith.hammerlib.client.flowgui.util.ScrollData;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.java.DirectStorage;
import org.zeith.hammerlib.util.math.Point;

public class GuiObject {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GuiObject.class);
    private static final Vec3 ONE = new Vec3(1.0, 1.0, 1.0);
    private GuiObject parent;
    private final List<GuiObject> children = new ArrayList<GuiObject>();
    private final Map<String, GuiObject> byName = new HashMap<String, GuiObject>();
    private final String originalName;
    private String name;
    private final String simpleName = this.getClass().getSimpleName();
    protected boolean enabled = true;
    protected boolean visible = true;
    protected float zOffset;
    protected Point pos = Point.ZERO;
    protected Point pivot = Point.ZERO;
    protected Vec3 scale = ONE;
    protected float width;
    protected float height;
    protected float rotation;
    public final DirectStorage<Point> elementPosition = DirectStorage.create(p -> this.pos(p.x(), p.y()), () -> this.pos);
    public final DirectStorage<Point> elementPivot = DirectStorage.create(p -> this.pivot(p.x(), p.y()), () -> this.pivot);
    public final DirectStorage<Vec3> elementScale = DirectStorage.create(p -> {
        this.scale = p;
    }, () -> this.scale);
    public final DirectStorage<Float> elementRotation = DirectStorage.create(p -> {
        this.rotation = p.floatValue();
    }, () -> Float.valueOf(this.rotation));
    public final DirectStorage<Float> elementWidth = DirectStorage.create(p -> {
        this.width = p.floatValue();
    }, () -> Float.valueOf(this.width));
    public final DirectStorage<Float> elementHeight = DirectStorage.create(p -> {
        this.height = p.floatValue();
    }, () -> Float.valueOf(this.height));

    public GuiObject(String name) {
        if (name.contains("/")) {
            throw new IllegalArgumentException("GuiObject's path can not have '/' character.");
        }
        this.originalName = this.name = name;
    }

    @Nullable
    public <T extends GuiObject> T findByName(String path, Class<T> expectType) {
        return (T)((GuiObject)Cast.cast(this.findByName(path), expectType));
    }

    @Nullable
    public <T extends GuiObject> T findByNameIgnoreCase(String path, Class<T> expectType) {
        return (T)((GuiObject)Cast.cast(this.findByNameIgnoreCase(path), expectType));
    }

    @Nullable
    public <T extends GuiObject> T findByPath(String path, Class<T> expectType) {
        return (T)((GuiObject)Cast.cast(this.findByPath(path), expectType));
    }

    @Nullable
    public GuiObject findByName(String path) {
        ArrayList<GuiObject> allChildren = new ArrayList<GuiObject>();
        allChildren.add(this);
        for (int i = 0; i < allChildren.size(); ++i) {
            GuiObject c = (GuiObject)allChildren.get(i);
            if (c.getName().equals(path)) {
                return c;
            }
            for (GuiObject c2 : c.getChildren()) {
                allChildren.add(c2);
            }
        }
        return null;
    }

    @Nullable
    public GuiObject findByNameIgnoreCase(String path) {
        ArrayList<GuiObject> allChildren = new ArrayList<GuiObject>();
        allChildren.add(this);
        for (int i = 0; i < allChildren.size(); ++i) {
            GuiObject c = (GuiObject)allChildren.get(i);
            if (c.getName().equalsIgnoreCase(path)) {
                return c;
            }
            for (GuiObject c2 : c.getChildren()) {
                allChildren.add(c2);
            }
        }
        return null;
    }

    @Nullable
    public GuiObject findByPath(String path) {
        if (path.isBlank()) {
            return this;
        }
        int nextSlash = path.indexOf(47);
        if (nextSlash < 0) {
            return this.byName.get(path);
        }
        String name = path.substring(0, nextSlash);
        GuiObject o = this.byName.get(name);
        return o != null ? o.findByPath(path.substring(nextSlash + 1)) : null;
    }

    public final Iterable<GuiObject> getChildren() {
        return this.children;
    }

    public GuiObject getChild(String name) {
        return this.byName.get(name);
    }

    public final GuiObject addChild(GuiObject child) {
        if (child == this) {
            log.warn("Attempted to add {} into itself.", (Object)this);
            return this;
        }
        if (GuiObject.anyMatchesWithinTree(this, o -> o == child)) {
            log.warn("Attempted to add {} into {} but it is already in the vertical hierarchy.", (Object)child, (Object)this);
            return this;
        }
        child.remove();
        child.parent = this;
        this.children.add(child);
        if (this.byName.containsKey(child.getName())) {
            String pv = child.toString();
            child.setName(child.originalName);
            log.warn("Attempted to add {} into {} but the name is already bound. Renaming to {}.", new Object[]{pv, this, child.getName()});
            return this;
        }
        this.byName.put(child.getName(), child);
        return this;
    }

    public final GuiObject removeChild(String name) {
        GuiObject go = this.byName.remove(name);
        if (go == null) {
            return null;
        }
        this.children.remove(go);
        go.parent = null;
        go.name = go.originalName;
        return go;
    }

    public final void remove() {
        if (this.parent != null) {
            this.parent.removeChild(this.getName());
        }
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        if (this.parent != null) {
            int j = 0;
            Object on = name;
            while (this.parent.byName.containsKey(on)) {
                on = name + " (" + ++j + ")";
            }
            name = on;
            this.parent.byName.put(name, this);
            if (this.parent.byName.get(this.name) == this) {
                this.parent.byName.remove(this.name);
            }
        }
        this.name = name;
    }

    public GuiObject setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public GuiObject setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    public GuiObject centered(float width, float height) {
        this.pos((width - this.width) / 2.0f, (height - this.height) / 2.0f);
        return this;
    }

    public GuiObject centered(int width, int height) {
        this.pos((int)(((float)width - this.width) / 2.0f), (int)(((float)height - this.height) / 2.0f));
        return this;
    }

    public GuiObject pos(float x, float y) {
        this.pos = new Point(x, y);
        return this;
    }

    public GuiObject offset(float x, float y) {
        this.pos = this.pos.offset(x, y);
        return this;
    }

    public GuiObject size(float width, float height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public GuiObject pivot(float x, float y) {
        this.pivot = new Point(x, y);
        return this;
    }

    public GuiObject pivotAtCenter() {
        return this.pivot(this.width / 2.0f, this.height / 2.0f);
    }

    public GuiObject rotation(float rotation) {
        this.rotation = rotation;
        return this;
    }

    public GuiObject usePos(Consumer<DirectStorage<Point>> handler) {
        handler.accept(this.elementPosition);
        return this;
    }

    public GuiObject usePivot(Consumer<DirectStorage<Point>> handler) {
        handler.accept(this.elementPivot);
        return this;
    }

    public GuiObject useScale(Consumer<DirectStorage<Vec3>> handler) {
        handler.accept(this.elementScale);
        return this;
    }

    public GuiObject useRotation(Consumer<DirectStorage<Float>> handler) {
        handler.accept(this.elementRotation);
        return this;
    }

    protected void update() {
    }

    protected void render(Graphics gfx, MousePos pos) {
    }

    protected boolean onMouseClicked(Point globalMousePos, MousePos pos, int button) {
        return false;
    }

    protected boolean onMouseDragged(Point globalMousePos, MousePos pos, int button, MousePos dragPos) {
        return false;
    }

    protected boolean onMouseReleased(Point globalMousePos, MousePos pos, int button) {
        return false;
    }

    protected boolean onMouseScrolled(Point globalMousePos, MousePos pos, ScrollData delta) {
        return false;
    }

    protected void onMouseMoved(Point globalMousePos, MousePos pos) {
    }

    protected boolean onKeyPressed(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    protected boolean onKeyReleased(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    protected boolean onCharTyped(char codePoint, int modifiers) {
        return false;
    }

    public final void sendUpdate() {
        if (!this.enabled) {
            return;
        }
        if (this.visible) {
            this.update();
        }
        for (GuiObject child : this.children) {
            child.sendUpdate();
        }
    }

    public final <T> void runForTree(PoseStack pose, Class<T> filter, BiConsumer<T, PoseStack> handler) {
        this.runForTree(pose, (obj, ps) -> {
            Object t = Cast.cast(obj, filter);
            if (t != null) {
                handler.accept(t, (PoseStack)ps);
            }
        });
    }

    public final <T, R> Optional<R> findInTree(PoseStack pose, Class<T> filter, BiFunction<T, PoseStack, Optional<R>> handler) {
        return this.findInTree(pose, (obj, ps) -> {
            Object t = Cast.cast(obj, filter);
            if (t != null) {
                return (Optional)handler.apply(t, (PoseStack)ps);
            }
            return Optional.empty();
        });
    }

    public final void runForTree(PoseStack pose, BiConsumer<GuiObject, PoseStack> handler) {
        if (!this.enabled) {
            return;
        }
        pose.pushPose();
        this.transform(pose);
        if (this.visible) {
            handler.accept(this, pose);
        }
        for (GuiObject child : this.children) {
            child.runForTree(pose, handler);
        }
        pose.popPose();
    }

    public final <R> Optional<R> findInTree(PoseStack pose, BiFunction<GuiObject, PoseStack, Optional<R>> handler) {
        Optional<R> o;
        if (!this.enabled) {
            return Optional.empty();
        }
        pose.pushPose();
        this.transform(pose);
        if (this.visible && (o = handler.apply(this, pose)).isPresent()) {
            pose.popPose();
            return o;
        }
        for (GuiObject child : this.children) {
            Optional<R> o2 = child.findInTree(pose, handler);
            if (!o2.isPresent()) continue;
            pose.popPose();
            return o2;
        }
        pose.popPose();
        return Optional.empty();
    }

    public final void renderObject(Graphics g, Point globalMousePos) {
        if (!this.enabled) {
            return;
        }
        PoseStack ps = g.gfx().pose();
        ps.pushPose();
        this.transform(ps);
        if (this.visible) {
            Vector3f v = GuiObject.untransform(ps).transformPosition(globalMousePos.x(), globalMousePos.y(), 0.0f, new Vector3f());
            this.render(g, new MousePos(globalMousePos, v.x, v.y));
        }
        for (GuiObject child : this.children) {
            child.renderObject(g, globalMousePos);
        }
        ps.popPose();
    }

    public final boolean sendMouseClick(PoseStack ps, Point globalMousePos, int button) {
        if (!this.enabled) {
            return false;
        }
        ps.pushPose();
        this.transform(ps);
        if (this.visible) {
            Vector3f v = GuiObject.untransform(ps).transformPosition(globalMousePos.x(), globalMousePos.y(), 0.0f, new Vector3f());
            if (this.onMouseClicked(globalMousePos, new MousePos(globalMousePos, v.x, v.y), button)) {
                return true;
            }
        }
        for (GuiObject child : this.children) {
            if (!child.sendMouseClick(ps, globalMousePos, button)) continue;
            return true;
        }
        ps.popPose();
        return false;
    }

    public final boolean sendMouseDrag(PoseStack ps, Point globalMousePos, int button, Point globalDragPos) {
        if (!this.enabled) {
            return false;
        }
        ps.pushPose();
        this.transform(ps);
        if (this.visible) {
            Matrix4f ivm = GuiObject.untransform(ps);
            Vector3f v = ivm.transformPosition(globalMousePos.x(), globalMousePos.y(), 0.0f, new Vector3f());
            Vector3f d = ivm.transformPosition(globalDragPos.x(), globalDragPos.y(), 0.0f, new Vector3f());
            if (this.onMouseDragged(globalMousePos, new MousePos(globalMousePos, v.x, v.y), button, new MousePos(globalDragPos, d.x, d.y))) {
                return true;
            }
        }
        for (GuiObject child : this.children) {
            if (!child.sendMouseDrag(ps, globalMousePos, button, globalDragPos)) continue;
            return true;
        }
        ps.popPose();
        return false;
    }

    public final boolean sendMouseRelease(PoseStack ps, Point globalMousePos, int button) {
        if (!this.enabled) {
            return false;
        }
        ps.pushPose();
        this.transform(ps);
        if (this.visible) {
            Vector3f v = GuiObject.untransform(ps).transformPosition(globalMousePos.x(), globalMousePos.y(), 0.0f, new Vector3f());
            if (this.onMouseReleased(globalMousePos, new MousePos(globalMousePos, v.x, v.y), button)) {
                return true;
            }
        }
        for (GuiObject child : this.children) {
            if (!child.sendMouseRelease(ps, globalMousePos, button)) continue;
            return true;
        }
        ps.popPose();
        return false;
    }

    public final boolean sendMouseScroll(PoseStack ps, Point globalMousePos, ScrollData delta) {
        if (!this.enabled) {
            return false;
        }
        ps.pushPose();
        this.transform(ps);
        if (this.visible) {
            Vector3f v = GuiObject.untransform(ps).transformPosition(globalMousePos.x(), globalMousePos.y(), 0.0f, new Vector3f());
            if (this.onMouseScrolled(globalMousePos, new MousePos(globalMousePos, v.x, v.y), delta)) {
                return true;
            }
        }
        for (GuiObject child : this.children) {
            if (!child.sendMouseScroll(ps, globalMousePos, delta)) continue;
            return true;
        }
        ps.popPose();
        return false;
    }

    public final void sendMouseMove(PoseStack ps, Point globalMousePos) {
        if (!this.enabled) {
            return;
        }
        ps.pushPose();
        this.transform(ps);
        if (this.visible) {
            Vector3f v = GuiObject.untransform(ps).transformPosition(globalMousePos.x(), globalMousePos.y(), 0.0f, new Vector3f());
            this.onMouseMoved(globalMousePos, new MousePos(globalMousePos, v.x, v.y));
        }
        for (GuiObject child : this.children) {
            child.sendMouseMove(ps, globalMousePos);
        }
        ps.popPose();
    }

    public final boolean sendKeyPress(int keyCode, int scanCode, int modifiers) {
        if (!this.enabled) {
            return false;
        }
        if (this.visible && this.onKeyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        for (GuiObject child : this.children) {
            if (!child.sendKeyPress(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    public final boolean sendKeyRelease(int keyCode, int scanCode, int modifiers) {
        if (!this.enabled) {
            return false;
        }
        if (this.visible && this.onKeyReleased(keyCode, scanCode, modifiers)) {
            return true;
        }
        for (GuiObject child : this.children) {
            if (!child.sendKeyRelease(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    public final boolean sendCharType(char codePoint, int modifiers) {
        if (!this.enabled) {
            return false;
        }
        if (this.visible && this.onCharTyped(codePoint, modifiers)) {
            return true;
        }
        for (GuiObject child : this.children) {
            if (!child.sendCharType(codePoint, modifiers)) continue;
            return true;
        }
        return false;
    }

    public void transform(PoseStack ps) {
        ps.translate(this.pos.x(), this.pos.y(), this.zOffset);
        if (this.scale != ONE) {
            ps.scale((float)this.scale.x, (float)this.scale.y, (float)this.scale.z);
        }
        ps.translate(this.pivot.x(), this.pivot.y(), 0.0f);
        ps.mulPose(Axis.ZP.rotationDegrees(this.rotation));
        ps.translate(-this.pivot.x(), -this.pivot.y(), 0.0f);
    }

    public String toString() {
        return this.simpleName + "{" + this.getName() + "}";
    }

    public static GuiRootObject root() {
        return new GuiRootObject();
    }

    public static GuiObjectBuilder create(String s) {
        return GuiObjectBuilder.named(s);
    }

    public static Matrix4f untransform(PoseStack pose) {
        return pose.last().pose().invert(new Matrix4f());
    }

    protected static boolean anyMatchesWithinTree(GuiObject root, Predicate<GuiObject> obj) {
        for (GuiObject child : root.children) {
            if (!GuiObject.anyMatchesWithinTree(child, obj)) continue;
            return true;
        }
        while (root != null) {
            if (obj.test(root)) {
                return true;
            }
            root = root.parent;
        }
        return false;
    }

    public GuiObject scale(float scale) {
        this.scale = this.scale.scale((double)scale);
        return this;
    }

    public GuiObject scale(float x, float y) {
        return this.scale(x, y, x);
    }

    public GuiObject scale(float x, float y, float z) {
        this.scale = this.scale.multiply((double)x, (double)y, (double)z);
        return this;
    }
}

