/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.registrars;

import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.jetbrains.annotations.Nullable;
import org.zeith.hammerlib.abstractions.recipes.IRecipeVisualizer;
import org.zeith.hammerlib.abstractions.recipes.IVisualizedRecipeType;
import org.zeith.hammerlib.api.fml.ICustomRegistrar;
import org.zeith.hammerlib.util.java.Cast;

public abstract class SerializableRecipeType<T extends Recipe<?>>
implements RecipeType<T>,
RecipeSerializer<T>,
ICustomRegistrar,
IVisualizedRecipeType<T> {
    public static final String DEFAULT_INGREDIENTS_KEY = "ingredients";
    public static final String DEFAULT_INGREDIENT_KEY = "ingredient";
    public static final String DEFAULT_OUTPUT_KEY = "result";
    public static final String DEFAULT_GROUP_KEY = "group";
    protected final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec = StreamCodec.of(this::toNetwork, this::fromNetwork);

    public abstract void toNetwork(RegistryFriendlyByteBuf var1, T var2);

    @Nullable
    public abstract T fromNetwork(RegistryFriendlyByteBuf var1);

    public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
        return this.streamCodec;
    }

    @Override
    public void performRegister(RegisterEvent event, ResourceLocation id) {
        event.register(Registries.RECIPE_TYPE, id, Cast.constant(this));
        event.register(Registries.RECIPE_SERIALIZER, id, Cast.constant(this));
    }

    @Override
    public void initVisuals(Consumer<IRecipeVisualizer<T, ?>> viualizerConsumer) {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{recipeTypeId=" + String.valueOf(BuiltInRegistries.RECIPE_TYPE.getKey((Object)this)) + ",recipeSerializerId=" + String.valueOf(BuiltInRegistries.RECIPE_SERIALIZER.getKey((Object)this)) + "}";
    }

    public ItemStack getToastSymbol(Recipe<?> recipe) {
        return new ItemStack((ItemLike)Blocks.CRAFTING_TABLE);
    }
}

