/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.forge;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.GsonHelper;

public class StreamCodecs {
    private static final Gson GSON = new Gson();

    public static <T> StreamCodec<RegistryFriendlyByteBuf, T> createRegistryAwareStreamCodec(Codec<T> codec) {
        return StreamCodec.of((buf, t) -> {
            DataResult res = codec.encodeStart((DynamicOps)RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)buf.registryAccess()), t);
            buf.writeUtf(GSON.toJson((JsonElement)res.getOrThrow(comp -> new EncoderException("Failed to encode: " + comp + " " + String.valueOf(t)))));
        }, buf -> {
            JsonElement jsonelement = (JsonElement)GsonHelper.fromJson((Gson)GSON, (String)buf.readUtf(), JsonElement.class);
            DataResult dataresult = codec.parse((DynamicOps)RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)buf.registryAccess()), (Object)jsonelement);
            return dataresult.getOrThrow(comp -> new DecoderException("Failed to decode json: " + comp));
        });
    }
}

