/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.forge;

import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import org.zeith.hammerlib.annotations.RegistryName;
import org.zeith.hammerlib.annotations.SimplyRegister;
import org.zeith.hammerlib.api.tiles.IContainerTile;
import org.zeith.hammerlib.util.java.Cast;

@SimplyRegister
public class ContainerAPI {
    @RegistryName(value="tile_container")
    public static final MenuType<AbstractContainerMenu> TILE_CONTAINER = IMenuTypeExtension.create((windowId, playerInv, extraData) -> {
        BlockEntity tile = playerInv.player.level().getBlockEntity(extraData.readBlockPos());
        return Cast.optionally(tile, IContainerTile.class).map(ict -> ict.openContainer(playerInv.player, windowId)).orElse(null);
    });

    public static MenuProvider forTile(final BlockEntity tile) {
        return new MenuProvider(){

            public Component getDisplayName() {
                return Cast.optionally(tile, IContainerTile.class).map(IContainerTile::getDisplayName).orElseGet(() -> tile.getBlockState().getBlock().getName());
            }

            @Nullable
            public AbstractContainerMenu createMenu(int windowId, Inventory playerInv, Player player) {
                return Cast.optionally(tile, IContainerTile.class).map(ict -> ict.openContainer(player, windowId)).orElse(null);
            }
        };
    }

    public static <T extends BlockEntity> void openContainerTile(Player player, T tile) {
        if (player instanceof ServerPlayer) {
            ServerPlayer mp = (ServerPlayer)player;
            if (tile != null) {
                mp.openMenu(ContainerAPI.forTile(tile), buf -> buf.writeBlockPos(tile.getBlockPos()));
            }
        }
    }
}

