/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.forge;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.extensions.IBlockEntityExtension;
import org.zeith.api.level.IBlockEntityLevel;
import org.zeith.hammerlib.api.tiles.ISidedTickableTile;
import org.zeith.hammerlib.core.adapter.BlockEntityAdapter;
import org.zeith.hammerlib.mixins.BlockEntityAccessor;
import org.zeith.hammerlib.tiles.TileSyncableTickable;

public class BlockAPI {
    public static <T extends BlockEntity> BlockEntityTicker<T> ticker() {
        return (level, pos, state, entity) -> {
            if (entity instanceof TileSyncableTickable) {
                TileSyncableTickable t = (TileSyncableTickable)entity;
                t.tick(level, pos, state, entity);
            }
        };
    }

    public static <T extends BlockEntity> BlockEntityTicker<T> ticker(Level lvl) {
        return lvl.isClientSide ? (level, pos, state, entity) -> {
            if (entity instanceof ISidedTickableTile) {
                ISidedTickableTile t = (ISidedTickableTile)entity;
                t.clientTick(level, pos, state, entity);
            }
        } : (level, pos, state, entity) -> {
            if (entity instanceof ISidedTickableTile) {
                ISidedTickableTile t = (ISidedTickableTile)entity;
                t.serverTick(level, pos, state, entity);
            }
        };
    }

    public static <T extends BlockEntity> BlockEntityType<T> createBlockEntityType(BlockEntityType.BlockEntitySupplier<T> generator, Block ... blocks) {
        return BlockEntityType.Builder.of(generator, (Block[])blocks).build(null);
    }

    public static <T extends BlockEntity> BlockEntityType<T> createBlockEntityType(DynamicBlockEntitySupplier<T> generator, Block ... blocks) {
        AtomicReference<BlockEntityType> typeRef = new AtomicReference<BlockEntityType>();
        typeRef.set(BlockEntityType.Builder.of((pos, state) -> generator.create((BlockEntityType)typeRef.get(), pos, state), (Block[])blocks).build(null));
        return (BlockEntityType)typeRef.get();
    }

    public static List<BlockEntity> getAllLoadedBlockEntities(Level level) {
        return IBlockEntityLevel.getLoadedBlockEntities(level);
    }

    public static <T extends BlockEntity> void spoofBlockEntityType(T be, BlockEntityType<T> type) {
        ((BlockEntityAccessor)be).setType_HammerLib(type);
    }

    public static synchronized void addBlocksToEntityType(BlockEntityType<?> type, Block ... blocks) {
        BlockEntityAdapter.addBlocksToEntityType(type, blocks);
    }

    public static void sendBlockUpdate(Level level, BlockPos pos) {
        if (level == null || pos == null) {
            return;
        }
        Optional.ofNullable(level.getBlockEntity(pos)).ifPresent(IBlockEntityExtension::requestModelDataUpdate);
        BlockState state = level.getBlockState(pos);
        level.sendBlockUpdated(pos, state, state, 3);
        level.blockUpdated(pos, state.getBlock());
        level.setBlockAndUpdate(pos, Block.updateFromNeighbourShapes((BlockState)state, (LevelAccessor)level, (BlockPos)pos));
    }

    @FunctionalInterface
    public static interface DynamicBlockEntitySupplier<T extends BlockEntity> {
        public T create(BlockEntityType<T> var1, BlockPos var2, BlockState var3);
    }
}

