/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.annotations.ap;

import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.neoforged.fml.ModList;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.annotations.ap.AnnotationFactory;
import org.zeith.hammerlib.annotations.ap.IAPContext;
import org.zeith.hammerlib.annotations.ap.IAnnotationProcessor;
import org.zeith.hammerlib.annotations.ap.RegisterAP;
import org.zeith.hammerlib.util.java.ReflectionUtil;
import org.zeith.hammerlib.util.mcf.ModHelper;
import org.zeith.hammerlib.util.mcf.ScanDataHelper;

public class AnnotationProcessorRegistry {
    private static final Map<Class<? extends Annotation>, List<IAnnotationProcessor<?>>> AP = new HashMap();
    private static final Map<Class<? extends Annotation>, IAnnotationObtainer<?, ?>> OBTAINERS = new HashMap();
    private static final Map<ElementPath, Map<Type, ModFileScanData.AnnotationData>> SCANNED;

    public static <T extends Annotation> void register(Class<T> annotation, IAnnotationProcessor<T> ap) {
        Retention ret = annotation.getAnnotation(Retention.class);
        if (ret != null && ret.value() == RetentionPolicy.SOURCE) {
            throw new IllegalArgumentException("Annotation type " + annotation.getName() + " has source retention and thus can not be processed by HammerLib as it's not registered at all.");
        }
        AP.computeIfAbsent(annotation, v -> new ArrayList()).add(ap);
        OBTAINERS.computeIfAbsent(annotation, AnnotationProcessorRegistry::retrieverOf);
    }

    public static void scan(IAPContext ctx, Field f, Object value) {
        if (AP.isEmpty()) {
            return;
        }
        for (Annotation annotation : f.getDeclaredAnnotations()) {
            List<IAnnotationProcessor<?>> aps = AP.get(annotation.annotationType());
            if (aps == null) continue;
            for (IAnnotationProcessor<?> ap : aps) {
                ap.onScanned(ctx, annotation, f, value);
            }
        }
    }

    public static void scanReg(IAPContext ctx, Field f, Object value, boolean postReg) {
        if (AP.isEmpty()) {
            return;
        }
        Map<Type, ModFileScanData.AnnotationData> an = AnnotationProcessorRegistry.allAnnotationsFor(f);
        HashSet<Type> unvisited = new HashSet<Type>(an.keySet());
        for (Annotation annotation : f.getDeclaredAnnotations()) {
            unvisited.remove(Type.getType(annotation.annotationType()));
            List<IAnnotationProcessor<?>> aps = AP.get(annotation.annotationType());
            if (aps == null) continue;
            for (IAnnotationProcessor<?> ap : aps) {
                if (postReg) {
                    ap.onPostRegistered(ctx, annotation, f, value);
                    continue;
                }
                ap.onPreRegistered(ctx, annotation, f, value);
            }
        }
        for (Type type : unvisited) {
            Class t = ReflectionUtil.fetchClass(type);
            List<IAnnotationProcessor<?>> aps = AP.get(t);
            if (aps == null) continue;
            IAnnotationObtainer data = OBTAINERS.computeIfAbsent(t, AnnotationProcessorRegistry::retrieverOf);
            Object annotation = data.obtain(f);
            for (IAnnotationProcessor<?> ap : aps) {
                if (postReg) {
                    ap.onPostRegistered(ctx, annotation, f, value);
                    continue;
                }
                ap.onPreRegistered(ctx, annotation, f, value);
            }
        }
    }

    public static void scan(IAPContext ctx, Method m) {
        if (AP.isEmpty()) {
            return;
        }
        for (Annotation annotation : m.getDeclaredAnnotations()) {
            List<IAnnotationProcessor<?>> aps = AP.get(annotation.annotationType());
            if (aps == null) continue;
            for (IAnnotationProcessor<?> ap : aps) {
                ap.onScanned(ctx, annotation, m);
            }
        }
    }

    @NotNull
    public static <M extends AccessibleObject> Map<Type, ModFileScanData.AnnotationData> allAnnotationsFor(M member) {
        ElementPath path = new ElementPath(Type.getType(((Member)((Object)member)).getDeclaringClass()), ((Member)((Object)member)).getName());
        return SCANNED.getOrDefault(path, Map.of());
    }

    public static <T extends Annotation> IAnnotationObtainer<T, ?> retrieverOf(Class<T> type) {
        Retention ret = type.getAnnotation(Retention.class);
        if (ret != null && ret.value() == RetentionPolicy.RUNTIME) {
            return el -> el.getDeclaredAnnotation(type);
        }
        Type at = Type.getType(type);
        return el -> {
            ModFileScanData.AnnotationData ad = AnnotationProcessorRegistry.allAnnotationsFor(el).getOrDefault(at, null);
            if (ad == null) {
                return null;
            }
            return AnnotationFactory.annotation(type, ad.annotationData());
        };
    }

    static {
        boolean forced = ModHelper.isClient();
        for (ScanDataHelper.ModAwareAnnotationData data : ScanDataHelper.lookupAnnotatedObjects(RegisterAP.class)) {
            boolean clientOnly = (Boolean)data.getProperty("clientOnly").orElse(false);
            Type type = data.getProperty("value").orElse(null);
            if (type == null || !forced && clientOnly) continue;
            Class t = ReflectionUtil.fetchClass(type);
            try {
                AnnotationProcessorRegistry.register(t, (IAnnotationProcessor)IAnnotationProcessor.class.cast(data.getOwnerClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0])));
                HammerLib.LOG.info("Register AP {} for {}.", data.getOwnerClass(), t);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
        SCANNED = (Map)Util.make(new HashMap(), m -> {
            for (ModFileScanData dat : ModList.get().getAllScanData()) {
                for (ModFileScanData.AnnotationData ad : dat.getAnnotations()) {
                    Map ads = m.computeIfAbsent(new ElementPath(ad.clazz(), ad.memberName()), __ -> new HashMap());
                    ads.put(ad.annotationType(), ad);
                }
            }
        });
    }

    public static interface IAnnotationObtainer<T extends Annotation, M extends AccessibleObject> {
        @Nullable
        public T obtain(M var1);
    }

    private record ElementPath(Type cls, String member) {
    }
}

