/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.api.wrench;

import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.zeith.api.wrench.IWrenchable;
import org.zeith.hammerlib.core.init.TagsHL;
import org.zeith.hammerlib.util.java.Cast;

public interface IWrenchItem {
    default public boolean canWrench(ItemStack stack) {
        return true;
    }

    public void playWrenchSound(UseOnContext var1);

    public static boolean isWrench(ItemStack stack) {
        IWrenchItem it;
        Item item;
        return !stack.isEmpty() && (stack.is(TagsHL.Items.TOOLS_WRENCH) || (item = stack.getItem()) instanceof IWrenchItem && (it = (IWrenchItem)item).canWrench(stack));
    }

    public static boolean performWrenchAction(UseOnContext context) {
        ItemStack item = context.getItemInHand();
        if (!IWrenchItem.isWrench(item)) {
            return false;
        }
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = world.getBlockState(pos);
        Block blk = state.getBlock();
        if (Cast.firstInstanceof(IWrenchable.class, world.getBlockEntity(pos), blk).map(w -> w.onWrenchUsed(context)).orElse(false).booleanValue()) {
            Item item2 = item.getItem();
            if (item2 instanceof IWrenchItem) {
                IWrenchItem it = (IWrenchItem)item2;
                it.playWrenchSound(context);
            }
            return true;
        }
        return false;
    }
}

