/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.api.registry;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.numbers.NumberFormatType;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.StatType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSizeType;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.levelgen.feature.rootplacers.RootPlacerType;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProviderType;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.crafting.IngredientType;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.fluids.crafting.FluidIngredientType;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforge.registries.holdersets.HolderSetType;
import org.zeith.hammerlib.util.java.Cast;

public class RegistryMapping {
    @Generated
    private static final Lock $LOCK = new ReentrantLock();
    private static final BiMap<Class<?>, Registry<?>> REG_BY_TYPE = HashBiMap.create();
    private static final BiMap<ResourceKey<?>, Class<?>> TYPE_BY_REG = HashBiMap.create();
    private static final Set<ResourceKey<?>> NON_INTRUSIVE_REGISTRIES = new HashSet();
    private static final Map<ResourceKey<? extends Registry<?>>, Codec<?>> REGISTRY_CODECS;

    public static <T> void markRegistryAsNonIntrusive(ResourceKey<? extends Registry<T>> registryKey) {
        $LOCK.lock();
        try {
            NON_INTRUSIVE_REGISTRIES.add(registryKey);
        }
        finally {
            $LOCK.unlock();
        }
    }

    public static synchronized <T> void report(Class<? super T> base, Registry<T> registry) {
        $LOCK.lock();
        try {
            REG_BY_TYPE.put(base, registry);
            TYPE_BY_REG.put((Object)registry.key(), base);
        }
        finally {
            $LOCK.unlock();
        }
    }

    public static synchronized <T> void report(Class<T> base, Registry<T> registry, boolean intrusive) {
        $LOCK.lock();
        try {
            REG_BY_TYPE.put(base, registry);
            TYPE_BY_REG.put((Object)registry.key(), base);
            if (!intrusive) {
                RegistryMapping.markRegistryAsNonIntrusive(registry.key());
            }
        }
        finally {
            $LOCK.unlock();
        }
    }

    public static synchronized void reportRaw(Class base, Registry registry) {
        $LOCK.lock();
        try {
            REG_BY_TYPE.put((Object)base, (Object)registry);
            TYPE_BY_REG.put((Object)registry.key(), (Object)base);
        }
        finally {
            $LOCK.unlock();
        }
    }

    public static synchronized void reportRaw(Class base, Registry registry, boolean intrusive) {
        $LOCK.lock();
        try {
            REG_BY_TYPE.put((Object)base, (Object)registry);
            TYPE_BY_REG.put((Object)registry.key(), (Object)base);
            if (!intrusive) {
                RegistryMapping.markRegistryAsNonIntrusive(registry.key());
            }
        }
        finally {
            $LOCK.unlock();
        }
    }

    public static <T> Class<T> getSuperType(Registry<T> registry) {
        if (registry == null) {
            return null;
        }
        return RegistryMapping.getSuperType(registry.key());
    }

    public static <T> Class<T> getSuperType(ResourceKey<? extends Registry<?>> registry) {
        if (registry == null) {
            return null;
        }
        return (Class)Cast.cast(TYPE_BY_REG.get(registry));
    }

    public static <T> Registry<T> getRegistryByType(Class<T> registry) {
        if (registry == null) {
            return null;
        }
        return (Registry)Cast.cast(REG_BY_TYPE.get(registry));
    }

    public static boolean isNonIntrusive(ResourceKey<? extends Registry<?>> registry) {
        return registry != null && NON_INTRUSIVE_REGISTRIES.contains(registry);
    }

    public static <T> Codec<T> registryCodec(ResourceKey<? extends Registry<T>> key) {
        return (Codec)Cast.cast(REGISTRY_CODECS.computeIfAbsent(key, regKey -> RegistryMapping.createRegistryCodec(key)));
    }

    private static <T> Codec<T> createRegistryCodec(ResourceKey<? extends Registry<T>> key) {
        return ResourceLocation.CODEC.flatXmap(id -> {
            Registry registry = (Registry)BuiltInRegistries.REGISTRY.get(key);
            return Optional.ofNullable(registry.get(id)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry key in " + String.valueOf(key) + ": " + String.valueOf(id)));
        }, obj -> {
            Registry registry = (Registry)BuiltInRegistries.REGISTRY.get(key);
            return registry.getResourceKey(obj).map(ResourceKey::location).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry element in " + String.valueOf(key) + ":" + String.valueOf(obj)));
        });
    }

    static {
        RegistryMapping.report(Block.class, BuiltInRegistries.BLOCK);
        RegistryMapping.report(Fluid.class, BuiltInRegistries.FLUID);
        RegistryMapping.report(Item.class, BuiltInRegistries.ITEM);
        RegistryMapping.report(MobEffect.class, BuiltInRegistries.MOB_EFFECT, false);
        RegistryMapping.report(SoundEvent.class, BuiltInRegistries.SOUND_EVENT, false);
        RegistryMapping.report(Potion.class, BuiltInRegistries.POTION, false);
        RegistryMapping.report(Attribute.class, BuiltInRegistries.ATTRIBUTE, false);
        RegistryMapping.report(VillagerType.class, BuiltInRegistries.VILLAGER_TYPE, false);
        RegistryMapping.report(VillagerProfession.class, BuiltInRegistries.VILLAGER_PROFESSION, false);
        RegistryMapping.report(PoiType.class, BuiltInRegistries.POINT_OF_INTEREST_TYPE, false);
        RegistryMapping.report(Schedule.class, BuiltInRegistries.SCHEDULE, false);
        RegistryMapping.report(Activity.class, BuiltInRegistries.ACTIVITY, false);
        RegistryMapping.report(ChunkStatus.class, BuiltInRegistries.CHUNK_STATUS, false);
        RegistryMapping.report(ArmorMaterial.class, BuiltInRegistries.ARMOR_MATERIAL, false);
        RegistryMapping.report(Instrument.class, BuiltInRegistries.INSTRUMENT, false);
        RegistryMapping.report(CatVariant.class, BuiltInRegistries.CAT_VARIANT, false);
        RegistryMapping.report(FrogVariant.class, BuiltInRegistries.FROG_VARIANT, false);
        RegistryMapping.reportRaw(MapDecorationType.class, BuiltInRegistries.MAP_DECORATION_TYPE);
        RegistryMapping.reportRaw(StructurePieceType.class, BuiltInRegistries.STRUCTURE_PIECE);
        RegistryMapping.report(LootItemConditionType.class, BuiltInRegistries.LOOT_CONDITION_TYPE, false);
        RegistryMapping.report(FluidType.class, NeoForgeRegistries.FLUID_TYPES, false);
        RegistryMapping.report(HolderSetType.class, NeoForgeRegistries.HOLDER_SET_TYPES, false);
        RegistryMapping.reportRaw(AttachmentType.class, NeoForgeRegistries.ATTACHMENT_TYPES, false);
        RegistryMapping.reportRaw(FluidIngredientType.class, NeoForgeRegistries.FLUID_INGREDIENT_TYPES, false);
        RegistryMapping.reportRaw(IngredientType.class, NeoForgeRegistries.INGREDIENT_TYPES, false);
        RegistryMapping.reportRaw(EntityDataSerializer.class, NeoForgeRegistries.ENTITY_DATA_SERIALIZERS, false);
        RegistryMapping.reportRaw(EntityType.class, (Registry)BuiltInRegistries.ENTITY_TYPE);
        RegistryMapping.reportRaw(BlockEntityType.class, BuiltInRegistries.BLOCK_ENTITY_TYPE);
        RegistryMapping.reportRaw(ParticleType.class, BuiltInRegistries.PARTICLE_TYPE, false);
        RegistryMapping.reportRaw(MenuType.class, BuiltInRegistries.MENU, false);
        RegistryMapping.reportRaw(RecipeType.class, BuiltInRegistries.RECIPE_TYPE, false);
        RegistryMapping.reportRaw(RecipeSerializer.class, BuiltInRegistries.RECIPE_SERIALIZER, false);
        RegistryMapping.reportRaw(StatType.class, BuiltInRegistries.STAT_TYPE, false);
        RegistryMapping.reportRaw(MemoryModuleType.class, (Registry)BuiltInRegistries.MEMORY_MODULE_TYPE, false);
        RegistryMapping.reportRaw(SensorType.class, (Registry)BuiltInRegistries.SENSOR_TYPE, false);
        RegistryMapping.reportRaw(WorldCarver.class, BuiltInRegistries.CARVER, false);
        RegistryMapping.reportRaw(Feature.class, BuiltInRegistries.FEATURE, false);
        RegistryMapping.reportRaw(StructureType.class, BuiltInRegistries.STRUCTURE_TYPE, false);
        RegistryMapping.reportRaw(BlockStateProviderType.class, BuiltInRegistries.BLOCKSTATE_PROVIDER_TYPE, false);
        RegistryMapping.reportRaw(PlacementModifierType.class, BuiltInRegistries.PLACEMENT_MODIFIER_TYPE, false);
        RegistryMapping.reportRaw(FoliagePlacerType.class, BuiltInRegistries.FOLIAGE_PLACER_TYPE, false);
        RegistryMapping.reportRaw(TrunkPlacerType.class, BuiltInRegistries.TRUNK_PLACER_TYPE, false);
        RegistryMapping.reportRaw(TreeDecoratorType.class, BuiltInRegistries.TREE_DECORATOR_TYPE, false);
        RegistryMapping.reportRaw(RootPlacerType.class, BuiltInRegistries.ROOT_PLACER_TYPE, false);
        RegistryMapping.reportRaw(FeatureSizeType.class, BuiltInRegistries.FEATURE_SIZE_TYPE, false);
        RegistryMapping.reportRaw(ArgumentTypeInfo.class, BuiltInRegistries.COMMAND_ARGUMENT_TYPE, false);
        RegistryMapping.reportRaw(CriterionTrigger.class, BuiltInRegistries.TRIGGER_TYPES, false);
        RegistryMapping.reportRaw(NumberFormatType.class, BuiltInRegistries.NUMBER_FORMAT_TYPE, false);
        RegistryMapping.reportRaw(StructureProcessorType.class, BuiltInRegistries.STRUCTURE_PROCESSOR, false);
        RegistryMapping.reportRaw(StructurePoolElementType.class, BuiltInRegistries.STRUCTURE_POOL_ELEMENT, false);
        RegistryMapping.reportRaw(StructurePlacementType.class, BuiltInRegistries.STRUCTURE_PLACEMENT, false);
        RegistryMapping.reportRaw(ItemSubPredicate.Type.class, BuiltInRegistries.ITEM_SUB_PREDICATE_TYPE, false);
        REGISTRY_CODECS = new ConcurrentHashMap();
    }
}

