/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.item.block;

import com.jerry.mekextras.common.attachments.containers.energy.ExtraComponentBackedEnergyCubeContainer;
import com.jerry.mekextras.common.block.ExtraBlockEnergyCube;
import com.jerry.mekextras.common.block.attribute.ExtraAttribute;
import com.jerry.mekextras.common.item.block.ExtraItemBlockTooltip;
import com.jerry.mekextras.common.tier.ECTier;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mekanism.api.RelativeSide;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.attachments.component.AttachedEjector;
import mekanism.common.attachments.component.AttachedSideConfig;
import mekanism.common.attachments.containers.energy.EnergyContainersBuilder;
import mekanism.common.config.MekanismConfig;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.registration.impl.CreativeTabDeferredRegister;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.StorageUtils;
import mekanism.common.util.text.EnergyDisplay;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtraItemBlockEnergyCube
extends ExtraItemBlockTooltip<ExtraBlockEnergyCube>
implements CreativeTabDeferredRegister.ICustomCreativeTabContents {
    public static final AttachedSideConfig SIDE_CONFIG = ExtraItemBlockEnergyCube.sideConfig(AttachedSideConfig.LightConfigInfo.FRONT_OUT_EJECT);
    public static final AttachedSideConfig ALL_INPUT = (AttachedSideConfig)Util.make(() -> {
        EnumMap<RelativeSide, DataType> sideData = new EnumMap<RelativeSide, DataType>(RelativeSide.class);
        for (RelativeSide side : EnumUtils.SIDES) {
            sideData.put(side, DataType.INPUT);
        }
        return ExtraItemBlockEnergyCube.sideConfig(new AttachedSideConfig.LightConfigInfo(sideData, false));
    });
    public static final AttachedSideConfig ALL_OUTPUT = (AttachedSideConfig)Util.make(() -> {
        EnumMap<RelativeSide, DataType> sideData = new EnumMap<RelativeSide, DataType>(RelativeSide.class);
        for (RelativeSide side : EnumUtils.SIDES) {
            sideData.put(side, DataType.OUTPUT);
        }
        return ExtraItemBlockEnergyCube.sideConfig(new AttachedSideConfig.LightConfigInfo(sideData, true));
    });

    private static AttachedSideConfig sideConfig(AttachedSideConfig.LightConfigInfo energyConfig) {
        EnumMap<TransmissionType, AttachedSideConfig.LightConfigInfo> configInfo = new EnumMap<TransmissionType, AttachedSideConfig.LightConfigInfo>(TransmissionType.class);
        configInfo.put(TransmissionType.ITEM, AttachedSideConfig.LightConfigInfo.FRONT_OUT_NO_EJECT);
        configInfo.put(TransmissionType.ENERGY, energyConfig);
        return new AttachedSideConfig(configInfo);
    }

    public ExtraItemBlockEnergyCube(ExtraBlockEnergyCube block, Item.Properties properties) {
        super(block, true, properties.component((Supplier)MekanismDataComponents.EJECTOR, (Object)AttachedEjector.DEFAULT).component((Supplier)MekanismDataComponents.SIDE_CONFIG, (Object)SIDE_CONFIG));
    }

    @Override
    public ECTier getAdvanceTier() {
        return ExtraAttribute.getAdvanceTier(this.getBlock(), ECTier.class);
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        StorageUtils.addStoredEnergy((ItemStack)stack, tooltip, (boolean)true);
        tooltip.add((Component)MekanismLang.CAPACITY.translateColored(EnumColor.INDIGO, new Object[]{EnumColor.GRAY, EnergyDisplay.of((long)this.getAdvanceTier().getMaxEnergy())}));
        super.appendHoverText(stack, context, tooltip, flag);
    }

    @Override
    protected void addTypeDetails(@NotNull ItemStack stack, @Nullable Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
    }

    public boolean isBarVisible(@NotNull ItemStack stack) {
        return stack.getCount() == 1;
    }

    public int getBarWidth(@NotNull ItemStack stack) {
        return StorageUtils.getEnergyBarWidth((ItemStack)stack);
    }

    public int getBarColor(@NotNull ItemStack stack) {
        return MekanismConfig.client.energyColor.get();
    }

    public void addItems(Holder<Item> item, Consumer<ItemStack> tabOutput) {
        tabOutput.accept(StorageUtils.getFilledEnergyVariant(item));
    }

    public boolean addDefault() {
        return super.addDefault();
    }

    @Override
    protected EnergyContainersBuilder addDefaultEnergyContainers(EnergyContainersBuilder builder) {
        return builder.addContainer(ExtraComponentBackedEnergyCubeContainer::create);
    }
}

