/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.content.network.transmitter;

import com.jerry.mekextras.common.tier.transmitter.PTier;
import com.jerry.mekextras.common.tile.transmitter.ExtraTileEntityTransmitter;
import com.jerry.mekextras.common.util.IExtraUpgradeableTransmitter;
import mekanism.api.Action;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.common.content.network.FluidNetwork;
import mekanism.common.content.network.transmitter.MechanicalPipe;
import mekanism.common.lib.transmitter.ConnectionType;
import mekanism.common.lib.transmitter.acceptor.AcceptorCache;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.upgrade.transmitter.MechanicalPipeUpgradeData;
import mekanism.common.upgrade.transmitter.TransmitterUpgradeData;
import mekanism.common.util.EnumUtils;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtraMechanicalPipe
extends MechanicalPipe
implements IMekanismFluidHandler,
IExtraUpgradeableTransmitter<MechanicalPipeUpgradeData> {
    public ExtraMechanicalPipe(Holder<Block> blockProvider, ExtraTileEntityTransmitter tile) {
        super(blockProvider, (TileEntityTransmitter)tile);
    }

    public void pullFromAcceptors() {
        if (!this.hasPullSide || this.getAvailablePull() <= 0) {
            return;
        }
        AcceptorCache acceptorCache = this.getAcceptorCache();
        for (Direction side : EnumUtils.DIRECTIONS) {
            FluidStack bufferWithFallback;
            FluidStack received;
            IFluidHandler connectedAcceptor;
            if (!this.isConnectionType(side, ConnectionType.PULL) || (connectedAcceptor = (IFluidHandler)acceptorCache.getConnectedAcceptor(side)) == null || (received = (bufferWithFallback = this.getBufferWithFallback()).isEmpty() ? connectedAcceptor.drain(this.getAvailablePull(), IFluidHandler.FluidAction.SIMULATE) : connectedAcceptor.drain(bufferWithFallback.copyWithAmount(this.getAvailablePull()), IFluidHandler.FluidAction.SIMULATE)).isEmpty() || !this.takeFluid(received, Action.SIMULATE).isEmpty()) continue;
            this.takeFluid(connectedAcceptor.drain(received, IFluidHandler.FluidAction.EXECUTE), Action.EXECUTE);
        }
    }

    private int getAvailablePull() {
        return this.hasTransmitterNetwork() ? Math.min(PTier.getPipePullAmount(this.tier), ((FluidNetwork)this.getTransmitterNetwork()).fluidTank.getNeeded()) : Math.min(PTier.getPipePullAmount(this.tier), this.buffer.getNeeded());
    }

    public long getCapacity() {
        return PTier.getPipeCapacity(this.tier);
    }

    @Override
    @Nullable
    public MechanicalPipeUpgradeData getUpgradeData() {
        return super.getUpgradeData();
    }

    @Override
    public boolean dataTypeMatches(@NotNull TransmitterUpgradeData data) {
        return super.dataTypeMatches(data);
    }

    @Override
    public void parseUpgradeData(@NotNull MechanicalPipeUpgradeData data) {
        super.parseUpgradeData(data);
    }
}

